/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import pios.emulator.printer.Inch;
import pios.emulator.printer.PrinterEngine;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.EmulatedMedia;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.models.PrinterAttributesModel;
import pios.emulator.printer.models.PrinterRequirementModel;
import pios.emulator.printer.models.StateModel;
import pios.emulator.printer.output.Margin;
import pios.emulator.printer.output.OutputView;
import pios.emulator.printer.output.PrintCanvas;

public class MediaModel
extends AbstractTableModel {
    private static final String MEDIA = PrinterPerf.getResourceString("MediaModel_Media");
    private static final String CONTINUOUS = PrinterPerf.getResourceString("MediaModel_Continuous");
    private static final String PAPERCOUNT = PrinterPerf.getResourceString("MediaModel_PaperCount");
    private static final String PAPERLENGTH = PrinterPerf.getResourceString("MediaModel_PaperLength");
    private static final String INCH = PrinterPerf.getResourceString("MediaModel_Inch");
    private static final String CM = PrinterPerf.getResourceString("MediaModel_CM");
    private static final String NAME = PrinterPerf.getResourceString("MediaModel_Name");
    private static final String SIZEINCH = PrinterPerf.getResourceString("MediaModel_SizeInch");
    private static final String MARGININCH = PrinterPerf.getResourceString("MediaModel_MarginInch");
    private static final String PREPRINT = PrinterPerf.getResourceString("MediaModel_Preprint");
    private static final String GAPSINCH = PrinterPerf.getResourceString("MediaModel_GapInch");
    private static final String UNEXPECTED = PrinterPerf.getResourceString("MediaModel_Unexpected");
    private static final String SUPPORTED = PrinterPerf.getResourceString("MediaModel_Supported");
    private static final String PROPERTY_FILENAME = "SupportedMedia";
    private static final String KEY_SUPPORTED = "SupportedMedia";
    private static final String KEY_SUPPORTED_PHW = "SupportedPrintHeadWidth";
    private static final String KEY_CURRENT_PHW = "CurrentPrintHeadWidth";
    private static final String SUFFIX_SIZE = ".Size";
    private static final String SUFFIX_MARGIN = ".Margin";
    private static final String SUFFIX_PREPRINT = ".Preprint";
    private static final String KEY_CURRENT = "CurrentMedia";
    private static final String KEY_PAPERCOUNT = "PaperCount";
    private static final String KEY_PAPERLENGTH = "PaperLength";
    private static final String KEY_LENGTH_DISPLAY_UNIT = "PaperLengthDispalyUnit";
    private static final String DELIMETER = ",";
    private static DeviceCapability continuous = new DeviceCapability("continuous", CONTINUOUS, "CONTINUOUS_PAPER", null);
    private static float[] supportedPrintHeadWidths;
    private static float currentPrintHeadWidth;
    private static final int sizeWidth = 0;
    private static final int sizeHeight = 1;
    private static final int marginTop = 0;
    private static final int marginLeft = 1;
    private static final int marginBottom = 2;
    private static final int marginRight = 3;
    private static final String[] EnglishNumbers;
    private static String title;
    private static final String[] Headers;
    private static final int[] columnWidths;
    private static final String[] LengthUnits;
    private static int paperCount;
    private static int paperLength;
    private static int lengthUnitIndex;
    private static String currentMediaName;
    private static Hashtable mediaList;
    private static Vector mediaIndexes;

    private static void parseRange(String string, boolean bl) {
    }

    public static String[] getLengthUnits() {
        return LengthUnits;
    }

    private static void addMedia(int n, String string, EmulatedMedia emulatedMedia) {
        mediaList.put(string, emulatedMedia);
        mediaIndexes.add(n, string);
    }

    public static void setCurrentPrintHeadWidthByIndex(int n) {
        currentPrintHeadWidth = supportedPrintHeadWidths[n];
    }

    public static int getCurrentPrintHeadWidthIndex() {
        int n = 0;
        while (n < supportedPrintHeadWidths.length) {
            if (supportedPrintHeadWidths[n] >= currentPrintHeadWidth) {
                return n;
            }
            ++n;
        }
        return supportedPrintHeadWidths.length - 1;
    }

    private static Properties createDefaults() {
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Letter";
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "8.5,11");
        string = "Legal";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "8.5,14");
        string = "A3";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "11.69,16.54");
        string = "A4";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "8.27,11.67");
        string = "B4";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "10.12,14.33");
        string = "B5";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "7.17,10.12");
        string = "Plain11x17";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "11,17");
        string = "Plain4x8";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "4,8");
        properties.put(string + SUFFIX_MARGIN, "0.2,0.2,0.2,0.2");
        string = "2x4_in_4x8";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "4,8");
        properties.put(string + SUFFIX_MARGIN, "0.2,0.2,0.2,0.2");
        properties.put(string + SUFFIX_PREPRINT, "2,4,0.05,0.05");
        string = "Continuous_1";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "1,0");
        string = "Continuous_2";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "2,0");
        string = "Continuous_3";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "3,0");
        string = "Continuous_4";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "4,0");
        string = "Continuous_8.5";
        stringBuffer.append(DELIMETER);
        stringBuffer.append(string);
        properties.put(string + SUFFIX_SIZE, "8.5,0");
        properties.put("SupportedMedia", stringBuffer.toString());
        properties.put(KEY_CURRENT, "A4");
        continuous.setEnabled(false);
        properties.put(KEY_PAPERLENGTH, PreferenceModel.getInstance().getStringProperty("continuous.paper.length.default"));
        properties.put(KEY_LENGTH_DISPLAY_UNIT, Integer.toString(lengthUnitIndex));
        properties.put(KEY_PAPERCOUNT, PreferenceModel.getInstance().getStringProperty("pagecount.default"));
        properties.put(continuous.getPropertyName(), continuous.getPropertyValue());
        properties.put(KEY_SUPPORTED_PHW, "1,2,3,4,8.27,8.5,12");
        properties.put(KEY_CURRENT_PHW, "8.5");
        PrinterEngine.storeProperties(false, "SupportedMedia", properties);
        return properties;
    }

    public static String getPaperAlias(float f) {
        if (Math.abs((double)f - 8.27) <= (double)0.001f) {
            return "A4";
        }
        return "";
    }

    public static void store() {
        CharSequence charSequence;
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = mediaIndexes.elements();
        while (enumeration.hasMoreElements()) {
            charSequence = (String)enumeration.nextElement();
            EmulatedMedia emulatedMedia = (EmulatedMedia)mediaList.get(charSequence);
            properties.put((String)charSequence + SUFFIX_MARGIN, emulatedMedia.getMarginString());
            properties.put((String)charSequence + SUFFIX_SIZE, emulatedMedia.getSizeString());
            properties.put((String)charSequence + SUFFIX_PREPRINT, emulatedMedia.getPreprintString());
            stringBuffer.append((String)charSequence);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(DELIMETER);
        }
        properties.put("SupportedMedia", stringBuffer.toString());
        properties.put(KEY_CURRENT, currentMediaName);
        properties.put(KEY_PAPERLENGTH, Integer.toString(paperLength));
        properties.put(KEY_LENGTH_DISPLAY_UNIT, Integer.toString(lengthUnitIndex));
        properties.put(KEY_PAPERCOUNT, Integer.toString(paperCount));
        properties.put(continuous.getPropertyName(), continuous.getPropertyValue());
        charSequence = new StringBuffer();
        int n = 0;
        while (n < supportedPrintHeadWidths.length) {
            if (0 != n) {
                ((StringBuffer)charSequence).append(DELIMETER);
            }
            ((StringBuffer)charSequence).append(supportedPrintHeadWidths[n]);
            ++n;
        }
        properties.put(KEY_SUPPORTED_PHW, ((StringBuffer)charSequence).toString());
        properties.put(KEY_CURRENT_PHW, Float.toString(currentPrintHeadWidth));
        PrinterEngine.storeProperties(true, "SupportedMedia", properties);
        MediaModel.resetAttribute();
    }

    private static void loadMediaConfiguration() {
        Properties properties = PrinterEngine.loadProperties("SupportedMedia");
        if (null == properties) {
            properties = MediaModel.createDefaults();
        }
        String string = properties.getProperty("SupportedMedia");
        paperCount = Integer.parseInt(properties.getProperty(KEY_PAPERCOUNT));
        continuous.setEnabled(properties.getProperty(continuous.getPropertyName()));
        MediaModel.setContinuousPrinting(continuous.getEnabled());
        String string2 = properties.getProperty(KEY_SUPPORTED_PHW);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, DELIMETER);
        supportedPrintHeadWidths = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            MediaModel.supportedPrintHeadWidths[n++] = Float.parseFloat(stringTokenizer.nextToken());
        }
        currentPrintHeadWidth = Float.parseFloat(properties.getProperty(KEY_CURRENT_PHW));
        currentMediaName = properties.getProperty(KEY_CURRENT);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, DELIMETER);
        int n2 = 0;
        while (stringTokenizer2.hasMoreTokens()) {
            EmulatedMedia emulatedMedia;
            String string3 = stringTokenizer2.nextToken();
            String string4 = properties.getProperty(string3 + SUFFIX_SIZE);
            String string5 = properties.getProperty(string3 + SUFFIX_MARGIN);
            String string6 = properties.getProperty(string3 + SUFFIX_PREPRINT);
            Inch[] inchArray = MediaModel.parseSizeString(string4);
            if (null == string6 || 0 == string6.length()) {
                emulatedMedia = new EmulatedMedia(inchArray[0], inchArray[1], MediaModel.parseMarginString(string5));
            } else {
                double[] dArray = MediaModel.parseValueString(string6);
                emulatedMedia = new EmulatedMedia(inchArray[0], inchArray[1], MediaModel.parseMarginString(string5), (int)dArray[0], (int)dArray[1], new Inch(dArray[2]), new Inch(dArray[3]));
            }
            MediaModel.addMedia(n2, string3, emulatedMedia);
            ++n2;
        }
        paperLength = Integer.parseInt(properties.getProperty(KEY_PAPERLENGTH));
        lengthUnitIndex = Integer.parseInt(properties.getProperty(KEY_LENGTH_DISPLAY_UNIT));
        if (lengthUnitIndex < 0) {
            lengthUnitIndex = 0;
        }
        if (lengthUnitIndex > 1) {
            lengthUnitIndex = 1;
        }
        if (!MediaModel.getCurrentMedia().isSupported()) {
            MediaModel.autoSelectMedia();
        }
    }

    private static Margin parseMarginString(String string) {
        if (null == string || 0 == string.length()) {
            return new Margin();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMETER);
        Inch[] inchArray = new Inch[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            inchArray[n++] = new Inch(Double.parseDouble(stringTokenizer.nextToken()));
        }
        return new Margin(inchArray[0], inchArray[1], inchArray[2], inchArray[3]);
    }

    private static Inch[] parseSizeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMETER);
        Inch[] inchArray = new Inch[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            inchArray[n++] = new Inch(Double.parseDouble(stringTokenizer.nextToken()));
        }
        return inchArray;
    }

    private static double[] parseValueString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMETER);
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            dArray[n++] = Double.parseDouble(stringTokenizer.nextToken());
        }
        return dArray;
    }

    public static Vector getActiveList() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = mediaIndexes.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EmulatedMedia emulatedMedia = (EmulatedMedia)mediaList.get(string);
            if (!emulatedMedia.isSupported()) continue;
            vector.add(string);
        }
        return vector;
    }

    public static String getTitle() {
        return title;
    }

    public static EmulatedMedia getMedia(String string) {
        return (EmulatedMedia)mediaList.get(string);
    }

    public static EmulatedMedia getCurrentMedia() {
        return (EmulatedMedia)mediaList.get(currentMediaName);
    }

    public static String getCurrentMediaName() {
        return currentMediaName;
    }

    public static void setCurrentMediaName(String string) {
        currentMediaName = string;
        MediaModel.updateState();
        PrintCanvas.getInstance().resetSize();
        OutputView.getInstance().resetSize();
    }

    public static void setPageCount(int n) {
        paperCount = n;
        MediaModel.updateState();
    }

    public static void setPapaerLength(int n, int n2) {
        paperLength = n;
        lengthUnitIndex = n2;
        MediaModel.updateState();
    }

    public static int getLengthUnitIndex() {
        return lengthUnitIndex;
    }

    public static int getPageCount() {
        return paperCount;
    }

    public static float getCurrentPrintHeadWidth() {
        return currentPrintHeadWidth;
    }

    public static int getContinuousPaperLength() {
        return paperLength;
    }

    public static Inch getContinuousPaperLengthInch() {
        if (0 == lengthUnitIndex) {
            return new Inch(paperLength);
        }
        return new Inch((double)paperLength / 2.54);
    }

    public static boolean getContinuousPrinting() {
        return continuous.getEnabled();
    }

    public static void setContinuousPrinting(boolean bl) {
        continuous.setEnabled(bl);
        if (bl) {
            paperCount = 1;
        } else if (paperCount < PreferenceModel.getInstance().getIntProperty("papercount.min") || paperCount > PreferenceModel.getInstance().getIntProperty("pagecount.max")) {
            paperCount = PreferenceModel.getInstance().getIntProperty("pagecount.default");
        }
    }

    public static float[] getSupportedPrintHeadWidth() {
        return supportedPrintHeadWidths;
    }

    private static void autoSelectMedia() {
        if (!PreferenceModel.getInstance().getBooleanProperty("auto.select.media")) {
            return;
        }
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < mediaIndexes.size()) {
            String string = (String)mediaIndexes.get(n);
            EmulatedMedia emulatedMedia = (EmulatedMedia)mediaList.get(string);
            if (emulatedMedia.isSupported() && emulatedMedia.getWidth().get() <= d) {
                d = emulatedMedia.getWidth().get();
                if (emulatedMedia.isContinuous()) {
                    MediaModel.setPageCount(1);
                } else {
                    MediaModel.setPageCount(PreferenceModel.getInstance().getIntProperty("pagecount.default"));
                }
                MediaModel.setCurrentMediaName(string);
            }
            ++n;
        }
        MediaModel.updateState();
    }

    public static void resetByRequirement() {
        continuous.resetByRequirement();
        PrinterRequirementModel printerRequirementModel = PrinterRequirementModel.getInstance();
        if (printerRequirementModel.isRequirementSelected("PAGE_WIDTH")) {
            boolean bl = false;
            Enumeration enumeration = printerRequirementModel.getRequirementKeys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("WIDTH_") || !printerRequirementModel.isRequirementSelected(string)) continue;
                String string2 = string.substring(6);
                MediaModel.parseRange(string2, bl);
                bl = true;
            }
        }
        if (!MediaModel.getCurrentMedia().isSupported()) {
            MediaModel.autoSelectMedia();
        }
    }

    public static void resetAttribute() {
        continuous.resetAttriubte();
        PrinterAttributesModel.getInstance().setAttribute(MediaModel.getCurrentMediaName(), true);
    }

    public static void updateState() {
        String string;
        String string2;
        if (MediaModel.getCurrentMedia().isContinuous()) {
            string2 = "";
            string = Integer.toString(paperLength) + " " + LengthUnits[lengthUnitIndex];
        } else {
            string2 = Integer.toString(paperCount);
            string = "";
        }
        StateModel.getInstance().set(PAPERCOUNT, string2);
        StateModel.getInstance().set(PAPERLENGTH, string);
        StateModel.getInstance().set(title, MediaModel.getCurrentMediaName());
    }

    public int getRowCount() {
        return mediaList.size();
    }

    public int getColumnCount() {
        return Headers.length;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public Object getValueAt(int n, int n2) {
        String string = (String)mediaIndexes.get(n);
        if (1 == n2) {
            return string;
        }
        EmulatedMedia emulatedMedia = (EmulatedMedia)mediaList.get(string);
        switch (n2) {
            case 0: {
                return emulatedMedia.isSupported() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return emulatedMedia.getSizeString();
            }
            case 3: {
                return emulatedMedia.getMarginString();
            }
            case 4: {
                return emulatedMedia.getCellString();
            }
            case 5: {
                return emulatedMedia.getSpaceString();
            }
        }
        return UNEXPECTED;
    }

    public String getColumnName(int n) {
        return Headers[n];
    }

    public int[] getColumnWidths() {
        return columnWidths;
    }

    static {
        continuous.setEnabled(false);
        EnglishNumbers = new String[]{"ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN"};
        Headers = new String[]{SUPPORTED, NAME, SIZEINCH, MARGININCH, PREPRINT, GAPSINCH};
        columnWidths = new int[]{175, 200, 175, 225, 175, 150};
        LengthUnits = new String[]{INCH, CM};
        paperCount = PreferenceModel.getInstance().getIntProperty("pagecount.default");
        paperLength = PreferenceModel.getInstance().getIntProperty("continuous.paper.length.default");
        lengthUnitIndex = 0;
        mediaList = new Hashtable();
        mediaIndexes = new Vector();
        title = MEDIA;
        MediaModel.loadMediaConfiguration();
    }
}

