/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.util.Hashtable;
import javax.swing.DefaultListModel;
import pios.emulator.printer.models.EmulatedImage;
import pios.emulator.printer.rmi.PrinterRemoteException;

public class ImageBufferModel
extends DefaultListModel {
    private static ImageBufferModel instance;
    private Hashtable imageList = new Hashtable();

    private ImageBufferModel() {
    }

    public static ImageBufferModel getInstance() {
        if (instance == null) {
            instance = new ImageBufferModel();
        }
        return instance;
    }

    public void addImage(String string, EmulatedImage emulatedImage) {
        this.deleteImage(string);
        this.addElement(emulatedImage.getName());
        this.imageList.put(string.toUpperCase(), emulatedImage);
    }

    public void deleteImage(String string) {
        try {
            EmulatedImage emulatedImage = this.getImage(string);
            this.removeElement(emulatedImage.getName());
            this.imageList.remove(string.toUpperCase());
        }
        catch (PrinterRemoteException printerRemoteException) {}
    }

    public EmulatedImage getImage(String string) throws PrinterRemoteException {
        EmulatedImage emulatedImage = (EmulatedImage)this.imageList.get(string.toUpperCase());
        if (null == emulatedImage) {
            throw new PrinterRemoteException(3, "Image not Found:" + string);
        }
        return emulatedImage;
    }

    public void reset() {
        this.imageList.clear();
        this.removeAllElements();
    }
}

