/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import pios.emulator.printer.PrinterEngine;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;
import pios.emulator.printer.models.FontFamily;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.models.StateModel;
import pios.emulator.printer.rmi.FontParameters;
import pios.emulator.printer.rmi.PrinterRemoteException;
import pios.emulator.ui.PResourceBundle;

public class FontModel
extends AbstractTableModel {
    private static final String BITMAPPEDFONT;
    private static final String SCALABLEFONT;
    private static final String DEFAULTFONT;
    private static final String FAMILYNAME;
    private static final String TYPE;
    private static final String STYLE;
    private static final String SIZE;
    private static final String FONT;
    private static final String UNEXPECTED;
    private static final String SUPPORTED;
    private static final String MISMATCHEDTYPE;
    private static final String PROPERTY_FILENAME = "InstalledFont";
    private static final String KEY_INSTALLED = "InstalledFontFamilies";
    private static final String SUFFIX_SIZES = ".Sizes";
    private static final String SUFFIX_STYLES = ".Styles";
    private static final String SUFFIX_TYPE = ".Type";
    private static final String KEY_DEFAULT_FAMILY = "DefaultFont.Family";
    private static final String KEY_DEFAULT_STYLE = "DefaultFont.Style";
    private static final String KEY_DEFAULT_SIZE = "DefaultFont.Size";
    private static final String DELIMETER = ",";
    private static final String[] Headers;
    private static final int[] columnWidths;
    private static String title;
    private static Hashtable fontCache;
    private static Hashtable installedFontFamilyList;
    private static Vector fontFamilyIndexes;
    public static DeviceCapability bitmappedFont;
    public static DeviceCapability scalableFont;
    private static String defaultFontFamilyName;
    private static int defaultFontStyle;
    private static double defaultFontSize;

    private static Properties createDefaults() {
        defaultFontFamilyName = "Courier New";
        FontModel.addFontFamily(0, new FontFamily(defaultFontFamilyName, 1, new int[]{0, 1, 2, 3}, new double[]{1.0, 2.0, 4.0, 6.0, 8.0, 9.0, 10.0, 12.0, 14.0, 16.0}));
        defaultFontStyle = 0;
        defaultFontSize = 8.0;
        FontModel.addFontFamily(1, new FontFamily("SansSerif", 2, new int[]{0, 1, 2, 3}, new double[]{1.0, 2.0, 4.0, 6.0, 8.0, 9.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0}));
        Properties properties = FontModel.createProperties();
        PrinterEngine.storeProperties(false, PROPERTY_FILENAME, properties);
        return properties;
    }

    private static void addFontFamily(int n, FontFamily fontFamily) {
        installedFontFamilyList.put(fontFamily.getFamilyName(), fontFamily);
        fontFamilyIndexes.add(n, fontFamily.getFamilyName());
    }

    public static void store() {
        Properties properties = FontModel.createProperties();
        PrinterEngine.storeProperties(true, PROPERTY_FILENAME, properties);
        FontModel.resetAttributes();
    }

    private static Properties createProperties() {
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = installedFontFamilyList.elements();
        while (enumeration.hasMoreElements()) {
            FontFamily fontFamily = (FontFamily)enumeration.nextElement();
            properties.put(fontFamily.getFamilyName() + SUFFIX_STYLES, fontFamily.getStylesString(true));
            properties.put(fontFamily.getFamilyName() + SUFFIX_SIZES, fontFamily.getSizesString());
            properties.put(fontFamily.getFamilyName() + SUFFIX_TYPE, Integer.toString(fontFamily.getType()));
            stringBuffer.append(fontFamily.getFamilyName());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(DELIMETER);
        }
        properties.put(KEY_INSTALLED, stringBuffer.toString());
        properties.put(KEY_DEFAULT_FAMILY, defaultFontFamilyName);
        properties.put(KEY_DEFAULT_STYLE, Integer.toString(defaultFontStyle));
        properties.put(KEY_DEFAULT_SIZE, Double.toString(defaultFontSize));
        properties.put(bitmappedFont.getPropertyName(), bitmappedFont.getPropertyValue());
        properties.put(scalableFont.getPropertyName(), scalableFont.getPropertyValue());
        return properties;
    }

    private static double[] parseSizesString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMETER);
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            dArray[n++] = Double.parseDouble(stringTokenizer.nextToken());
        }
        return dArray;
    }

    private static int[] parseStylesString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMETER);
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    private static void loadInstalledFontFamilies() {
        Properties properties = PrinterEngine.loadProperties(PROPERTY_FILENAME);
        if (null == properties) {
            properties = FontModel.createDefaults();
        }
        installedFontFamilyList.clear();
        fontFamilyIndexes.clear();
        String string = properties.getProperty(KEY_INSTALLED);
        defaultFontFamilyName = properties.getProperty(KEY_DEFAULT_FAMILY);
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMETER);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = properties.getProperty(string2 + SUFFIX_SIZES);
            String string4 = properties.getProperty(string2 + SUFFIX_STYLES);
            String string5 = properties.getProperty(string2 + SUFFIX_TYPE);
            FontFamily fontFamily = new FontFamily(string2, Integer.parseInt(string5), FontModel.parseStylesString(string4), FontModel.parseSizesString(string3));
            FontModel.addFontFamily(n, fontFamily);
            ++n;
        }
        defaultFontStyle = Integer.parseInt(properties.getProperty(KEY_DEFAULT_STYLE));
        defaultFontSize = Double.parseDouble(properties.getProperty(KEY_DEFAULT_SIZE));
        bitmappedFont.setEnabled(properties.getProperty(bitmappedFont.getPropertyName()));
        scalableFont.setEnabled(properties.getProperty(scalableFont.getPropertyName()));
    }

    public static Vector getFontFamilyList() {
        return (Vector)fontFamilyIndexes.clone();
    }

    public static Vector getActiveFontFamilyList() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = fontFamilyIndexes.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FontFamily fontFamily = (FontFamily)installedFontFamilyList.get(string);
            if (!fontFamily.isSupported()) continue;
            vector.add(string);
        }
        return vector;
    }

    public static String getDefaultFontFamilyName() {
        return defaultFontFamilyName;
    }

    public static FontParameters getDefaultFont() {
        FontFamily fontFamily = (FontFamily)installedFontFamilyList.get(defaultFontFamilyName);
        FontParameters fontParameters = fontFamily.getEmulatedFont(defaultFontSize);
        fontParameters.setFont(FontModel.createFont(fontFamily, defaultFontStyle, defaultFontSize));
        return fontParameters;
    }

    public static void implementFont(FontParameters fontParameters) throws PrinterRemoteException {
        FontFamily fontFamily = (FontFamily)installedFontFamilyList.get(fontParameters.getFamilyName());
        if (null == fontFamily) {
            throw new PrinterRemoteException(1, fontFamily.getFamilyName() + ":" + UNEXPECTED);
        }
        if (fontFamily.getType() != fontParameters.getType()) {
            throw new PrinterRemoteException(1, fontFamily.getFamilyName() + ":" + MISMATCHEDTYPE);
        }
        if (!fontFamily.isSupported()) {
            throw new PrinterRemoteException(2, fontFamily.getFamilyName());
        }
        int n = FontModel.chooseStyle(fontParameters, fontFamily);
        fontParameters.setFont(FontModel.createFont(fontFamily, n, fontParameters.getSize()));
    }

    private static int chooseStyle(FontParameters fontParameters, FontFamily fontFamily) {
        int n = fontFamily.getStyles()[0];
        if (fontParameters.hasOption(0L)) {
            n = 0;
        }
        if (fontParameters.hasOption(1L)) {
            n = fontFamily.getStyles()[0];
        }
        if (fontParameters.hasOption(2L)) {
            n = 1;
        }
        if (fontParameters.hasOption(4L)) {
            n = 2;
        }
        if (fontParameters.hasOption(2L) && fontParameters.hasOption(4L)) {
            n = 3;
        }
        return n;
    }

    private static Font createFont(FontFamily fontFamily, int n, double d) {
        String string = FontModel.toKey(fontFamily.getFamilyName(), n, d);
        if (fontCache.containsKey(string)) {
            return (Font)fontCache.get(string);
        }
        Font font = fontFamily.createFont(n, d);
        fontCache.put(string, font);
        return font;
    }

    private static String toKey(String string, int n, double d) {
        return string + n + d;
    }

    private static String getFontString(FontParameters fontParameters) {
        return fontParameters.getFamilyName() + "(" + fontParameters.getSize() + ")";
    }

    public static int getDefaultFontStyle() {
        return defaultFontStyle;
    }

    public static double getDefaultFontSize() {
        return defaultFontSize;
    }

    public static void resetAttributes() {
        bitmappedFont.resetAttriubte();
        scalableFont.resetAttriubte();
    }

    public static void resetByRequirement() {
        bitmappedFont.resetByRequirement();
        scalableFont.resetByRequirement();
        if (!FontModel.getDefaultFontFamily().isSupported()) {
            FontModel.autoSelectDefaultFont();
        }
    }

    private static void autoSelectDefaultFont() {
        if (!PreferenceModel.getInstance().getBooleanProperty("auto.select.font")) {
            return;
        }
        Enumeration enumeration = installedFontFamilyList.elements();
        while (enumeration.hasMoreElements()) {
            FontFamily fontFamily = (FontFamily)enumeration.nextElement();
            if (!fontFamily.isSupported() || null == fontFamily.createFont(defaultFontStyle, defaultFontSize)) continue;
            FontModel.setDefaultFont(fontFamily.getFamilyName(), defaultFontStyle, defaultFontSize);
            break;
        }
    }

    public static void setDefaultFont(String string, int n, double d) {
        defaultFontFamilyName = string;
        defaultFontStyle = n;
        defaultFontSize = d;
        FontModel.updateState();
    }

    public static FontFamily getFontFamily(String string) {
        return (FontFamily)installedFontFamilyList.get(string);
    }

    public static FontFamily getDefaultFontFamily() {
        return FontModel.getFontFamily(defaultFontFamilyName);
    }

    public static String getTitle() {
        return title;
    }

    public static void updateState() {
        StateModel.getInstance().set(DEFAULTFONT, FontModel.getFontString(FontModel.getDefaultFont()));
    }

    public int getRowCount() {
        return installedFontFamilyList.size();
    }

    public int getColumnCount() {
        return Headers.length;
    }

    public String getColumnName(int n) {
        return Headers[n];
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public Object getValueAt(int n, int n2) {
        String string = (String)fontFamilyIndexes.get(n);
        if (1 == n2) {
            return string;
        }
        FontFamily fontFamily = (FontFamily)installedFontFamilyList.get(string);
        switch (n2) {
            case 0: {
                return fontFamily.isSupported() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return fontFamily.getTypeString();
            }
            case 3: {
                return fontFamily.getStylesString(false);
            }
            case 4: {
                return fontFamily.getSizesString();
            }
        }
        return UNEXPECTED;
    }

    public int[] getColumnWidths() {
        return columnWidths;
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        BITMAPPEDFONT = pResourceBundle.getString("FontModel_BitmappedFont");
        SCALABLEFONT = pResourceBundle.getString("FontModel_ScalableFont");
        DEFAULTFONT = pResourceBundle.getString("FontModel_DefaultFont");
        FAMILYNAME = pResourceBundle.getString("FontModel_FamilyName");
        TYPE = pResourceBundle.getString("FontModel_Type");
        STYLE = pResourceBundle.getString("FontModel_Style");
        SIZE = pResourceBundle.getString("FontModel_Size");
        FONT = pResourceBundle.getString("FontModel_Font");
        UNEXPECTED = pResourceBundle.getString("FontModel_Unexpected");
        SUPPORTED = pResourceBundle.getString("FontModel_Supported");
        MISMATCHEDTYPE = pResourceBundle.getString("FontModel_MismatchedType");
        Headers = new String[]{SUPPORTED, FAMILYNAME, TYPE, STYLE, SIZE};
        columnWidths = new int[]{60, 60, 50, 200, 160};
        fontCache = new Hashtable();
        installedFontFamilyList = new Hashtable();
        fontFamilyIndexes = new Vector();
        bitmappedFont = new DeviceCapability("bitmappedFont", BITMAPPEDFONT, "FONT_BITMAPPED", null);
        scalableFont = new DeviceCapability("scalableFont", SCALABLEFONT, "FONT_SCALABLE", null);
        title = FONT;
        FontModel.loadInstalledFontFamilies();
    }
}

