/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.awt.Font;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.Units;
import pios.emulator.printer.models.FontModel;
import pios.emulator.printer.rmi.FontParameters;
import pios.emulator.printer.rmi.FontTypes;
import pios.emulator.ui.PResourceBundle;

public class FontFamily
implements FontTypes {
    private static final String PLAIN;
    private static final String BOLD;
    private static final String ITALIC;
    private static final String UNKNOWN;
    private static final String STR_SCALABLE;
    private static final String STR_BITMAPPED;
    public static final int OPTION_PLAIN = 0;
    public static final int OPTION_BOLD = 1;
    public static final int OPTION_ITALIC = 2;
    public static final int OPTION_BOLD_ITALIC = 3;
    private static final int[] fontStyles;
    private static final String[] styleStrings;
    private static final String[] typeStrings;
    private String familyName;
    private int type;
    private int[] styles;
    private double[] sizes;
    private FontParameters emulatedOne;

    public FontFamily(String string, int n, int[] nArray, double[] dArray) {
        this.familyName = string;
        this.type = n;
        this.styles = nArray;
        this.sizes = dArray;
    }

    public static String styleToString(int n) {
        return styleStrings[n];
    }

    public FontParameters getEmulatedFont(double d) {
        if (null == this.emulatedOne || d != this.emulatedOne.getSize()) {
            this.emulatedOne = this.type == 2 ? new FontParameters(this.familyName, 1L, d) : new FontParameters(this.familyName, 1L, d, 1, 1);
        }
        return this.emulatedOne;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int[] getStyles() {
        return this.styles;
    }

    public String getStylesString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.styles.length) {
            if (bl) {
                stringBuffer.append(Integer.toString(this.styles[n]));
            } else {
                stringBuffer.append(styleStrings[this.styles[n]]);
            }
            if (n < this.styles.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public double[] getSizes() {
        return this.sizes;
    }

    public String getSizesString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.sizes.length) {
            stringBuffer.append(Double.toString(this.sizes[n]));
            if (n < this.sizes.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getType() {
        return this.type;
    }

    public boolean isSupported() {
        return FontModel.bitmappedFont.getEnabled() && 1 == this.type || FontModel.scalableFont.getEnabled() && 2 == this.type;
    }

    public String getTypeString() {
        return typeStrings[this.type];
    }

    public Font createFont(int n, double d) {
        Font font = null;
        if (this.isAvailable(n, this.styles) && (2 == this.type || this.isAvailable(d, this.sizes))) {
            font = new Font(this.familyName, fontStyles[n], (int)Math.ceil(Units.pointToPixel(d)));
        }
        return font;
    }

    private boolean isAvailable(int n, int[] nArray) {
        boolean bl = false;
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n == nArray[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private boolean isAvailable(double d, double[] dArray) {
        boolean bl = false;
        if (dArray != null) {
            int n = 0;
            while (n < dArray.length) {
                if (d == dArray[n]) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        PLAIN = pResourceBundle.getString("FontFamily_PLAIN");
        BOLD = pResourceBundle.getString("FontFamily_BOLD");
        ITALIC = pResourceBundle.getString("FontFamily_ITALIC");
        UNKNOWN = pResourceBundle.getString("FontFamily_Unknown");
        STR_SCALABLE = pResourceBundle.getString("FontFamily_Scalable");
        STR_BITMAPPED = pResourceBundle.getString("FontFamily_Bitmapped");
        fontStyles = new int[]{0, 1, 2, 3};
        styleStrings = new String[]{PLAIN, BOLD, ITALIC, BOLD + "+" + ITALIC};
        typeStrings = new String[]{UNKNOWN, STR_BITMAPPED, STR_SCALABLE};
    }
}

