/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import pios.emulator.printer.Inch;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PreferenceModel;
import pios.emulator.printer.output.Margin;
import pios.emulator.ui.PResourceBundle;

public class EmulatedMedia {
    private static final String SIZETIP;
    private static final String PREPRINTTIP;
    static final float[] dash1;
    static final BasicStroke dashed;
    private Inch width;
    private Inch height;
    private Margin margin;
    private int numColumn;
    private int numRow;
    private Inch columnSpace;
    private Inch rowSpace;

    public EmulatedMedia(Inch inch, Inch inch2, Margin margin) {
        this.width = inch;
        this.height = inch2;
        this.margin = margin;
        this.numRow = 1;
        this.numColumn = 1;
        this.columnSpace = new Inch(0.0);
        this.rowSpace = new Inch(0.0);
    }

    public EmulatedMedia(Inch inch, Inch inch2, Margin margin, int n, int n2, Inch inch3, Inch inch4) {
        this(inch, inch2, margin);
        this.numColumn = n;
        this.numRow = n2;
        this.columnSpace = inch3;
        this.rowSpace = inch4;
    }

    public void resetSize(Inch inch, Inch inch2) {
        this.width = inch;
        this.height = inch2;
    }

    public boolean isContinuous() {
        return 0.0 == this.height.get();
    }

    public boolean isSupported() {
        if (MediaModel.getContinuousPrinting() != this.isContinuous()) {
            return false;
        }
        return !(this.width.get() > (double)MediaModel.getCurrentPrintHeadWidth()) && !(this.width.get() < 0.0);
    }

    public Inch getHeight() {
        if (0.0 != this.height.get()) {
            return this.height;
        }
        return MediaModel.getContinuousPaperLengthInch();
    }

    public Inch getWidth() {
        return this.width;
    }

    public String getSizeString() {
        String string = new String();
        string = this.width + "," + this.height;
        return string;
    }

    public static String getSizeTip() {
        return SIZETIP;
    }

    public String getMarginString() {
        return this.margin.toString();
    }

    public String getCellString() {
        String string = "";
        if (this.hasSticker()) {
            string = this.numColumn + "x" + this.numRow;
        }
        return string;
    }

    public String getSpaceString() {
        String string = "";
        if (this.hasSticker()) {
            string = this.columnSpace + " # " + this.rowSpace;
        }
        return string;
    }

    public String getPreprintString() {
        String string = "";
        if (this.hasSticker()) {
            string = this.numColumn + "," + this.numRow + "," + this.columnSpace.toString() + "," + this.rowSpace.toString();
        }
        return string;
    }

    public static String getPreprintTip() {
        return PREPRINTTIP;
    }

    public boolean hasSticker() {
        return this.numColumn > 1 || this.numRow > 1;
    }

    public void render(Graphics2D graphics2D) {
        double d = (this.width.getPixel() - this.margin.getTotalH() - this.columnSpace.getPixel() * (double)(this.numColumn - 1)) / (double)this.numColumn;
        double d2 = (this.getHeight().getPixel() - this.margin.getTotalV() - this.rowSpace.getPixel() * (double)(this.numRow - 1)) / (double)this.numRow;
        double d3 = this.margin.getLeft();
        double d4 = this.margin.getRight();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(dashed);
        int n = 0;
        while (n < this.numRow) {
            int n2 = 0;
            while (n2 < this.numColumn) {
                graphics2D.drawRoundRect((int)Math.ceil(d3), (int)Math.ceil(d4), (int)Math.ceil(d), (int)Math.ceil(d2), 10, 10);
                d3 += d + this.columnSpace.getPixel();
                ++n2;
            }
            d3 = this.margin.getLeft();
            d4 += d2 + this.rowSpace.getPixel();
            ++n;
        }
        Color color = graphics2D.getColor();
        graphics2D.setColor(PreferenceModel.getInstance().getColorProperty("color.pagebreak"));
        graphics2D.drawLine(0, (int)Math.ceil(this.height.getPixel()), (int)Math.ceil(this.width.getPixel()), (int)Math.ceil(this.height.getPixel()));
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        SIZETIP = pResourceBundle.getString("EmulatedMedia_SizeTip");
        PREPRINTTIP = pResourceBundle.getString("EmulatedMedia_PreprintTip");
        dash1 = new float[]{10.0f};
        dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    }
}

