/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import pios.emulator.printer.DimensionEx;

public final class EmulatedImage {
    public static final int TYPE_BMP = 1;
    public static final int TYPE_PCX = 2;
    private final String name;
    private final int type;
    private final byte[] data;
    DimensionEx size;
    Image image;

    public EmulatedImage(String string, int n, byte[] byArray) {
        this.name = string;
        this.type = n;
        this.data = byArray;
        this.size = new DimensionEx(0.0, 0.0);
        this.decodeImage();
    }

    public EmulatedImage(String string, double d, double d2) {
        this.name = string;
        this.type = 1;
        this.data = new byte[1];
        this.size = new DimensionEx(d, d2);
        this.createImage();
    }

    private void decodeImage() {
        switch (this.type) {
            case 1: {
                this.decodeBMP();
                break;
            }
            case 2: {
                this.decodePCX();
                break;
            }
        }
    }

    private void decodeBMP() {
        this.size.setSize(60.0, 30.0);
        this.createImage();
    }

    private void decodePCX() {
        this.size.setSize(30.0, 30.0);
        this.createImage();
    }

    private void createImage() {
        this.image = new BufferedImage((int)Math.ceil(this.size.getPixelWidth()), (int)Math.ceil(this.size.getPixelHeight()), 12);
        Graphics graphics = this.image.getGraphics();
        graphics.setXORMode(Color.black);
        graphics.drawString(this.name, 0, (int)Math.ceil(this.size.getPixelHeight()));
    }

    public Image getImage() {
        return this.image;
    }

    public DimensionEx getDimension() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }
}

