/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.GeneralCapabilityModel;
import pios.emulator.printer.models.PrinterAttributesModel;
import pios.emulator.printer.models.PrinterRequirementModel;
import pios.emulator.printer.rmi.PrinterRemoteException;

public class DeviceCapability {
    private static final String CLEARERROR = PrinterPerf.getResourceString("DeviceCapability_ClearError");
    private static final String SENDRAWBYTES = PrinterPerf.getResourceString("DeviceCapability_SendRawBytes");
    private static final String FORWARD = PrinterPerf.getResourceString("DeviceCapability_Forward");
    private static final String BACKWARD = PrinterPerf.getResourceString("DeviceCapability_Backward");
    private static final String PAGEMETRICS = PrinterPerf.getResourceString("DeviceCapability_PageMetrics");
    private static final String LINEMODE = PrinterPerf.getResourceString("DeviceCapability_LineMode");
    private static final String LINESPACING = PrinterPerf.getResourceString("DeviceCapability_LineSpacing");
    private static final String LINEALIGNMENT = PrinterPerf.getResourceString("DeviceCapability_LineAlignment");
    private static final String XYMODE = PrinterPerf.getResourceString("DeviceCapability_XYMode");
    private static final String TEXTROTATION = PrinterPerf.getResourceString("DeviceCapability_TextRotation");
    private static final String BARCODEROTATION = PrinterPerf.getResourceString("DeviceCapability_BarcodeRotation");
    private static final String IMAGEROTATION = PrinterPerf.getResourceString("DeviceCapability_ImageRotation");
    private static final String LINETHICKNESS = PrinterPerf.getResourceString("DeviceCapability_LineThickness");
    private static final String GRAPHICS = PrinterPerf.getResourceString("DeviceCapability_Graphics");
    private static final String IMAGE = PrinterPerf.getResourceString("DeviceCapability_Image");
    private static final String PRELOAD = PrinterPerf.getResourceString("DeviceCapability_Preload");
    private static final String DELETE = PrinterPerf.getResourceString("DeviceCapability_Delete");
    private static final String MONOBMP = PrinterPerf.getResourceString("DeviceCapability_MonoBMO");
    private static final String MONOPCX = PrinterPerf.getResourceString("DeviceCapability_MonoPCX");
    private static final String NOTSUPPORTED = PrinterPerf.getResourceString("DeviceCapability_NotSupported");
    public static DeviceCapability clearError = DeviceCapability.createGeneralCapability("ClearError", CLEARERROR, "CLEAR_PRINTER_ERROR", null);
    public static DeviceCapability sendRawBytes = DeviceCapability.createGeneralCapability("SendRawBytes", SENDRAWBYTES, "SEND_RAW_BYTES", null);
    public static DeviceCapability forward = DeviceCapability.createGeneralCapability("Forward", FORWARD, "ADVANCE_FORWARD", null);
    public static DeviceCapability backward = DeviceCapability.createGeneralCapability("Backward", BACKWARD, "ADVANCE_BACK", null);
    public static DeviceCapability pageMetrics = DeviceCapability.createGeneralCapability("PageMetrics", PAGEMETRICS, "PAGE_METRICS", null);
    public static DeviceCapability lineMode = DeviceCapability.createGeneralCapability("LineMode", LINEMODE, "LINE_MODE", null);
    public static DeviceCapability lineSpacing = DeviceCapability.createGeneralCapability("LineSpacing", LINESPACING, "LINE_SPACING", lineMode);
    public static DeviceCapability lineAlignment = DeviceCapability.createGeneralCapability("LineAlignment", LINEALIGNMENT, "LINE_ALIGNMENT", lineMode);
    public static DeviceCapability xyMode = DeviceCapability.createGeneralCapability("XYMode", XYMODE, "GRAPHIC_MODE", null);
    public static DeviceCapability textRotation = DeviceCapability.createGeneralCapability("TextRotation", TEXTROTATION, "TEXT_ROTATION", xyMode);
    public static DeviceCapability barcodeRotation = DeviceCapability.createGeneralCapability("BarcodeRotation", BARCODEROTATION, "BARCODE_ROTATION", xyMode);
    public static DeviceCapability imageRotation = DeviceCapability.createGeneralCapability("ImageRotation", IMAGEROTATION, "IMAGE_ROTATION", xyMode);
    public static DeviceCapability lineThickness = DeviceCapability.createGeneralCapability("LineThickness", LINETHICKNESS, null, xyMode);
    public static DeviceCapability graphics = DeviceCapability.createGeneralCapability("Graphics", GRAPHICS, "GRAPHICS", xyMode);
    public static DeviceCapability image = DeviceCapability.createGeneralCapability("Image", IMAGE, "IMAGE_PRINT", null);
    public static DeviceCapability preloadImage = DeviceCapability.createGeneralCapability("Preload", PRELOAD, "IMAGE_LOAD", image);
    public static DeviceCapability deleteImage = DeviceCapability.createGeneralCapability("Delete", DELETE, "IMAGE_DELETE", image);
    public static DeviceCapability formatBMP = DeviceCapability.createGeneralCapability("MonoBMP", MONOBMP, "IMAGE_BMP", image);
    public static DeviceCapability formatPCX = DeviceCapability.createGeneralCapability("MonoPCX", MONOPCX, "IMAGE_PCX", image);
    private String identification;
    private String displayName;
    private String requirementName;
    private String attributeName;
    private static int index = 0;
    private DeviceCapability parent;
    private boolean enabled;
    private boolean hasNoChildren;

    public DeviceCapability(String string, String string2) {
        this.identification = string;
        this.displayName = string2;
        this.attributeName = null;
        this.parent = null;
        this.enabled = true;
        this.hasNoChildren = true;
        ++index;
    }

    private DeviceCapability(String string, String string2, DeviceCapability deviceCapability) {
        this(string, string2);
        this.parent = deviceCapability;
        if (null != deviceCapability) {
            this.parent.hasNoChildren = false;
        }
    }

    public DeviceCapability(String string, String string2, String string3, DeviceCapability deviceCapability) {
        this(string, string2, deviceCapability);
        this.setRequirementName(string3);
    }

    private static DeviceCapability createGeneralCapability(String string, String string2, String string3, DeviceCapability deviceCapability) {
        DeviceCapability deviceCapability2 = new DeviceCapability(string, string2, string3, deviceCapability);
        GeneralCapabilityModel.registerCapability(deviceCapability2);
        return deviceCapability2;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setEnabled(String string) {
        if (null == string) {
            PrinterPerf.getLog().appendMessage("null value for :" + this.getPropertyName());
            this.setEnabled(true);
            return;
        }
        if (string.equalsIgnoreCase("1") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enabled")) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private void setRequirementName(String string) {
        this.requirementName = string;
        if (null == this.attributeName) {
            this.attributeName = string;
        }
    }

    public void resetByRequirement() {
        if (null != this.requirementName) {
            this.setEnabled(PrinterRequirementModel.getInstance().isRequirementSelected(this.requirementName));
            this.resetAttriubte();
        }
    }

    public void setAttributeName(String string) {
        this.attributeName = string;
        if (null == this.requirementName) {
            this.requirementName = string;
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getRequirementName() {
        return this.requirementName;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    public final String getIdentification() {
        return this.identification;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void verifyCapability() throws PrinterRemoteException {
        if (!this.getEnabled()) {
            throw new PrinterRemoteException(2, this.getDisplayName() + ":" + NOTSUPPORTED);
        }
    }

    public DeviceCapability getParent() {
        return this.parent;
    }

    public boolean getHasNoChildren() {
        return this.hasNoChildren;
    }

    public String getPropertyName() {
        if (null == this.parent) {
            return this.getIdentification();
        }
        return this.parent.getIdentification() + "." + this.getIdentification();
    }

    public String getPropertyValue() {
        return this.enabled ? "1" : "0";
    }

    public void resetAttriubte() {
        if (null == this.attributeName) {
            PrinterAttributesModel.getInstance().setAttribute(this.getPropertyName(), this.enabled);
        } else {
            PrinterAttributesModel.getInstance().setAttribute(this.attributeName, this.enabled);
        }
    }
}

