/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import pios.emulator.printer.PrinterEngine;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.DeviceCapability;

public abstract class CapabilityModel {
    protected abstract String getPropertyFilename();

    public abstract Vector getList();

    private Properties createDefaults() {
        Properties properties = new Properties();
        Enumeration enumeration = this.getList().elements();
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            deviceCapability.setEnabled(true);
            properties.put(deviceCapability.getPropertyName(), deviceCapability.getPropertyValue());
        }
        PrinterEngine.storeProperties(false, this.getPropertyFilename(), properties);
        return properties;
    }

    protected void initializeCapabilities() {
        Properties properties = PrinterEngine.loadProperties(this.getPropertyFilename());
        if (null == properties) {
            properties = this.createDefaults();
        }
        Enumeration enumeration = this.getList().elements();
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            String string = properties.getProperty(deviceCapability.getPropertyName());
            if (null == string) {
                PrinterPerf.getLog().appendWarning("?new property:" + deviceCapability.getPropertyName());
                string = "1";
            }
            deviceCapability.setEnabled(string);
        }
    }

    public void store() {
        Properties properties = new Properties();
        Enumeration enumeration = this.getList().elements();
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            properties.put(deviceCapability.getPropertyName(), deviceCapability.getPropertyValue());
        }
        PrinterEngine.storeProperties(true, this.getPropertyFilename(), properties);
        this.resetAttributes();
    }

    public void resetByRequirement() {
        Enumeration enumeration = this.getList().elements();
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            deviceCapability.resetByRequirement();
        }
        this.resynch(this.getList().elements());
    }

    protected void resynch(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            DeviceCapability deviceCapability2 = deviceCapability.getParent();
            if (null == deviceCapability2 || deviceCapability2.getEnabled()) continue;
            deviceCapability.setEnabled(false);
        }
    }

    public void resetAttributes() {
        Enumeration enumeration = this.getList().elements();
        while (enumeration.hasMoreElements()) {
            DeviceCapability deviceCapability = (DeviceCapability)enumeration.nextElement();
            deviceCapability.resetAttriubte();
        }
    }
}

