/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.models;

import java.util.Vector;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.CapabilityModel;
import pios.emulator.printer.output.barcodeprintout.CodabarPrintout;
import pios.emulator.printer.output.barcodeprintout.Code128Printout;
import pios.emulator.printer.output.barcodeprintout.Code39Printout;
import pios.emulator.printer.output.barcodeprintout.Code93Printout;
import pios.emulator.printer.output.barcodeprintout.DataMatrixPrintout;
import pios.emulator.printer.output.barcodeprintout.EAN13Printout;
import pios.emulator.printer.output.barcodeprintout.EAN8Printout;
import pios.emulator.printer.output.barcodeprintout.Industrial2of5Printout;
import pios.emulator.printer.output.barcodeprintout.Interleaved2of5Printout;
import pios.emulator.printer.output.barcodeprintout.Matrix2of5Printout;
import pios.emulator.printer.output.barcodeprintout.MaxiCodePrintout;
import pios.emulator.printer.output.barcodeprintout.MicroPDF417Printout;
import pios.emulator.printer.output.barcodeprintout.PDF417Printout;
import pios.emulator.printer.output.barcodeprintout.Standard2of5Printout;
import pios.emulator.printer.output.barcodeprintout.UCCEAN128Printout;
import pios.emulator.printer.output.barcodeprintout.UPCAPrintout;
import pios.emulator.printer.output.barcodeprintout.UPCEPrintout;
import pios.emulator.ui.PResourceBundle;

public final class BarcodeCapabilityModel
extends CapabilityModel {
    private static final String BARCODE;
    private static BarcodeCapabilityModel instance;
    private static final String PROPERTY_FILENAME = "BarcodeCapability";
    private int version = 2;
    private Vector barcodeList = new Vector();

    private BarcodeCapabilityModel() {
        CodabarPrintout.registerCapability(this.barcodeList);
        Code39Printout.registerCapability(this.barcodeList);
        Code128Printout.registerCapability(this.barcodeList);
        EAN8Printout.registerCapability(this.barcodeList);
        EAN13Printout.registerCapability(this.barcodeList);
        Interleaved2of5Printout.registerCapability(this.barcodeList);
        PDF417Printout.registerCapability(this.barcodeList);
        UCCEAN128Printout.registerCapability(this.barcodeList);
        UPCAPrintout.registerCapability(this.barcodeList);
        if (this.version > 2) {
            Code93Printout.registerCapability(this.barcodeList);
            Industrial2of5Printout.registerCapability(this.barcodeList);
            Standard2of5Printout.registerCapability(this.barcodeList);
            Matrix2of5Printout.registerCapability(this.barcodeList);
            UPCEPrintout.registerCapability(this.barcodeList);
            MaxiCodePrintout.registerCapability(this.barcodeList);
            MicroPDF417Printout.registerCapability(this.barcodeList);
            DataMatrixPrintout.registerCapability(this.barcodeList);
        }
        this.initializeCapabilities();
    }

    public static BarcodeCapabilityModel getInstance() {
        if (null == instance) {
            instance = new BarcodeCapabilityModel();
        }
        return instance;
    }

    public String getTitle() {
        return BARCODE;
    }

    protected String getPropertyFilename() {
        return PROPERTY_FILENAME;
    }

    public Vector getList() {
        return this.barcodeList;
    }

    public int getVersion() {
        return this.version;
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        BARCODE = pResourceBundle.getString("BarcodeCapabilityModel_Barcode");
        instance = null;
    }
}

