/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer;

import java.awt.Toolkit;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.ResolutionModel;
import pios.emulator.ui.PResourceBundle;

public final class Units {
    private static final String POINT;
    private static final String CM;
    private static final String INCH;
    public static final int NEUTROL = 0;
    public static final int METRIC = 1;
    public static final int ENGLISH = 2;
    private static final String[] unitStrings;
    private static final double screenDPI;

    private static double getPrinterDPI() {
        return ResolutionModel.getCurrentResolutionValue();
    }

    public static double mmToPoint(double d) {
        return Units.inchToPoint(Units.mmToInch(d));
    }

    public static double mmToPixel(double d) {
        return Units.pointToPixel(Units.mmToPoint(d));
    }

    public static double mmToInch(double d) {
        return d / 25.4;
    }

    public static double inchToPoint(double d) {
        return d * 72.0;
    }

    public static double getScreenDPI() {
        return screenDPI;
    }

    private static double getPixelToDotRatio() {
        return screenDPI / Units.getPrinterDPI();
    }

    public static double pointToDot(double d) {
        return d * Units.getPrinterDPI() / 72.0;
    }

    public static double dotToPoint(double d) {
        return d * 72.0 / Units.getPrinterDPI();
    }

    public static double dotToInch(double d) {
        return Units.dotToPixel(d) / Units.getScreenDPI();
    }

    public static double dotToPixel(double d) {
        return d * Units.getPixelToDotRatio();
    }

    public static double pointToPixel(double d) {
        return Units.pointToDot(d) * Units.getPixelToDotRatio();
    }

    public static double pointToInch(double d) {
        return d / 72.0;
    }

    public static double inchToPixel(double d) {
        return d * Units.getScreenDPI();
    }

    public static double pixelToInch(double d) {
        return d / Units.getScreenDPI();
    }

    public static double pixelToPoint(double d) {
        return Units.pixelToInch(d) * 72.0;
    }

    public static String getUnitString(int n) {
        return unitStrings[n];
    }

    static {
        PResourceBundle pResourceBundle = PrinterPerf.getResourceBundle();
        POINT = pResourceBundle.getString("Units_Point");
        CM = pResourceBundle.getString("Units_cm");
        INCH = pResourceBundle.getString("Units_Inch");
        unitStrings = new String[]{POINT, CM, INCH};
        screenDPI = Toolkit.getDefaultToolkit().getScreenResolution();
    }
}

