/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer;

import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import pios.emulator.PDefinition;
import pios.emulator.PEmulator;
import pios.emulator.PPeripheralException;
import pios.emulator.PPeripheralLog;
import pios.emulator.api.IPDataHandler;
import pios.emulator.api.IPLog;
import pios.emulator.api.IPPeripheral;
import pios.emulator.printer.PrinterEngine;
import pios.emulator.printer.Unimplemented;
import pios.emulator.printer.models.PrinterAttributesModel;
import pios.emulator.printer.models.PrinterRequirementModel;
import pios.emulator.printer.models.StatusModel;
import pios.emulator.printer.output.OutputView;
import pios.emulator.printer.output.StateView;
import pios.emulator.printer.rmi.PrinterEmServer;
import pios.emulator.printer.setups.ButtonEx;
import pios.emulator.ui.PResourceBundle;

public class PrinterPerf
implements IPPeripheral {
    protected static final String NAME = "Printer";
    private static final String LANGUAGE_RESOURCE_NAME = "pios.emulator.printer.language.printer";
    private static final PResourceBundle resource = new PResourceBundle("pios.emulator.printer.language.printer");
    private static final String PRINTER = PrinterPerf.getResourceString("PrinterPerf_Printer");
    private static ImageIcon DUMMY_ICON = null;
    private PrinterEngine printerPanel = null;
    private static PPeripheralLog log = null;
    private PrinterEmServer printerSrv = null;
    private Registry registry = null;
    private static PDefinition pDefinition;
    private Vector offlineItems = new Vector();
    private static final IPDataHandler unimplemented;

    public void startup(Object object, IPLog iPLog) throws PPeripheralException {
        try {
            this.registry = (Registry)object;
            this.printerSrv = new PrinterEmServer();
            this.registry.rebind("RemoteEmPrinter", this.printerSrv);
            iPLog.appendMessage("Connecting RemoteEmPrinter");
        }
        catch (RemoteException remoteException) {
            throw new PPeripheralException("Failed to initialize Printer peripheral.", (Throwable)remoteException);
        }
    }

    public void close() {
        block2: {
            if (this.registry == null) break block2;
            try {
                log.appendMessage("Closing RemoteEmPrinter");
                this.registry.unbind("RemoteEmPrinter");
            }
            catch (Exception exception) {}
        }
    }

    public IPDataHandler getDataHandler() {
        return unimplemented;
    }

    public boolean supportsData() {
        return false;
    }

    public void applyReq(Properties properties) {
        PrinterEngine.storeProperties(true, "requirements1", properties);
        log.appendMessage("Applying requirements document to the printer");
        PrinterRequirementModel.getInstance().applyRequirements(properties);
        PrinterEngine.storeProperties(true, "requirements2", properties);
    }

    public static PResourceBundle getResourceBundle() {
        return resource;
    }

    public static String getResourceString(String string) {
        return resource.getString(string);
    }

    public static ImageIcon getImageIcon(String string) {
        return PEmulator.getImageIcon((String)string);
    }

    public static String getPrinterPerfPath() {
        return PEmulator.getPaths().getPerfDir() + File.separator + NAME + File.separator;
    }

    public static boolean isDebugMode() {
        return PEmulator.isDebugMode();
    }

    public String getName() {
        return NAME;
    }

    public String getLocalizedName() {
        return PRINTER;
    }

    public String getImageName() {
        return "printer.gif";
    }

    public String toString() {
        return this.getName();
    }

    public String getVersion() {
        return pDefinition.getVersion();
    }

    public Properties getAttributes() {
        return PrinterPerf.getAttributesDefinition();
    }

    public static PPeripheralLog getLog() {
        if (log == null) {
            log = new PPeripheralLog(PEmulator.getLog(), NAME);
        }
        return log;
    }

    public static Properties getAttributesDefinition() {
        Properties properties = PrinterAttributesModel.getInstance().getAttributes();
        properties.putAll((Map<?, ?>)pDefinition);
        PrinterEngine.storeProperties(true, "attributes", properties);
        return properties;
    }

    public void initAttributes(PDefinition pDefinition) {
        PrinterPerf.getLog().appendMessage("Initializing the Printer's Attributes");
        PrinterPerf.pDefinition = pDefinition;
        PrinterAttributesModel.getInstance().resetAttributes();
    }

    public JPanel createUIContent() throws PPeripheralException {
        this.printerPanel = PrinterEngine.getInstance();
        return this.printerPanel;
    }

    public void populateToolbar(JToolBar jToolBar) {
        this.buttonToToolBar(jToolBar, StateView.getInstance().getOnOfflineButton());
        this.buttonToToolBar(jToolBar, StateView.getInstance().getLinefeedButton());
        this.buttonToToolBar(jToolBar, StateView.getInstance().getResetButton());
        this.buttonToToolBar(jToolBar, StateView.getInstance().getCapabilityButton());
        this.buttonToToolBar(jToolBar, StateView.getInstance().getSetupButton());
        StateView.getInstance().resetOfflineButtons();
    }

    public void populateMenu(JMenu jMenu) {
        this.buttonToMenu(jMenu, OutputView.getInstance().getUnitButton());
        jMenu.addSeparator();
        this.buttonToMenu(jMenu, StateView.getInstance().getOnOfflineButton());
        this.buttonToMenu(jMenu, StateView.getInstance().getLinefeedButton());
        this.buttonToMenu(jMenu, StateView.getInstance().getResetButton());
        jMenu.addSeparator();
        this.offlineItems.add(this.buttonToMenu(jMenu, StateView.getInstance().getCapabilityButton()));
        this.offlineItems.add(this.buttonToMenu(jMenu, StateView.getInstance().getSetupButton()));
        jMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = 0;
                while (n < PrinterPerf.this.offlineItems.size()) {
                    ((JMenuItem)PrinterPerf.this.offlineItems.get(n)).setEnabled(!StatusModel.isOnLine());
                    ++n;
                }
            }
        });
    }

    private JMenuItem buttonToMenu(JMenu jMenu, JButton jButton) {
        JMenuItem jMenuItem = new JMenuItem(jButton.getActionCommand());
        jMenuItem.setMnemonic(jButton.getMnemonic());
        jMenuItem.setIcon(jButton.getIcon());
        if (null == jMenuItem.getIcon()) {
            jMenuItem.setIcon(PrinterPerf.getDummyIcon());
        }
        ActionListener[] actionListenerArray = ((ButtonEx)jButton).getActionListeners();
        int n = 0;
        while (n < actionListenerArray.length) {
            jMenuItem.addActionListener(actionListenerArray[n]);
            ++n;
        }
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(jButton.isEnabled());
        return jMenuItem;
    }

    private void buttonToToolBar(JToolBar jToolBar, JButton jButton) {
        if (jButton.getIcon() != null && jButton.getIcon().getIconHeight() > 0) {
            jButton.setToolTipText(jButton.getActionCommand());
            jButton.setText(null);
        }
        jToolBar.add(jButton);
    }

    private static ImageIcon getDummyIcon() {
        if (null == DUMMY_ICON) {
            DUMMY_ICON = PrinterPerf.getImageIcon("dummy.gif");
        }
        return DUMMY_ICON;
    }

    public PrinterEmServer getServer() {
        return this.printerSrv;
    }

    public void setFocus() {
        this.printerPanel.requestFocus();
    }

    public boolean hasPendingChanges() {
        return false;
    }

    static {
        log = new PPeripheralLog((IPLog)log, NAME);
        pDefinition = null;
        unimplemented = new Unimplemented();
    }
}

