/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import pios.emulator.printer.PrinterPerf;
import pios.emulator.printer.models.BarcodeCapabilityModel;
import pios.emulator.printer.models.FontModel;
import pios.emulator.printer.models.GeneralCapabilityModel;
import pios.emulator.printer.models.ImageBufferModel;
import pios.emulator.printer.models.MediaModel;
import pios.emulator.printer.models.PrinterBufferModel;
import pios.emulator.printer.models.PrinterModeModel;
import pios.emulator.printer.models.ResolutionModel;
import pios.emulator.printer.models.StatusModel;
import pios.emulator.printer.output.OutputView;
import pios.emulator.printer.output.PrintCanvas;
import pios.emulator.printer.output.StateView;

public final class PrinterEngine
extends JPanel {
    private static PrinterEngine instance = null;
    private static final String DEFAULT = "dft";
    private static final String USERNAME = System.getProperty("user.name");
    private static final String PRINTER_DIR = PrinterPerf.getPrinterPerfPath();
    private JSplitPane splitPane;
    private OutputView outputView;
    private StateView stateView;

    public static PrinterEngine getInstance() {
        if (null == instance) {
            instance = new PrinterEngine();
        }
        return instance;
    }

    private PrinterEngine() {
        super(new BorderLayout());
        BarcodeCapabilityModel.getInstance();
        GeneralCapabilityModel.getInstance();
        PrinterEngine.reset();
        this.outputView = OutputView.getInstance();
        this.stateView = StateView.getInstance();
        this.splitPane = new JSplitPane(1, this.outputView, this.stateView);
        this.splitPane.setResizeWeight(1.0);
        this.add((Component)this.splitPane, "Center");
    }

    public static void reset() {
        PrinterBufferModel.getInstance().reset();
        StatusModel.reset();
        PrinterModeModel.reset();
        ImageBufferModel.getInstance().reset();
        PrintCanvas.getInstance().resetHeadPosition();
        PrintCanvas.getInstance().setLineSpace(0.0);
        OutputView.getInstance().resetSize();
        PrintCanvas.getInstance().repaint();
        ResolutionModel.updateState();
        MediaModel.updateState();
        FontModel.updateState();
        StateView.getInstance().resetOfflineButtons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void storeProperties(boolean bl, String string, Properties properties) {
        block14: {
            FileOutputStream fileOutputStream = null;
            FilterOutputStream filterOutputStream = null;
            String string2 = PRINTER_DIR + string + "." + (bl ? USERNAME : DEFAULT);
            fileOutputStream = new FileOutputStream(string2);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            properties.store(filterOutputStream, "");
            Object var8_6 = null;
            try {
                filterOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
            break block14;
            {
                catch (Exception exception) {
                    PrinterPerf.getLog().appendError("failed storing properties:" + string2, (Throwable)exception);
                    Object var8_7 = null;
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadProperties(String string) {
        Properties properties;
        block18: {
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                fileInputStream = new FileInputStream(PRINTER_DIR + string + "." + USERNAME);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    fileInputStream = new FileInputStream(PRINTER_DIR + string + "." + DEFAULT);
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    PrinterPerf.getLog().appendError("failed loading properties:" + string, (Throwable)fileNotFoundException);
                    return null;
                }
            }
            properties = new Properties();
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            properties.load(bufferedInputStream);
            Object var6_7 = null;
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            break block18;
            {
                catch (Exception exception) {
                    PrinterPerf.getLog().appendError("failed loading properties:" + string, (Throwable)exception);
                    Object var6_8 = null;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    static {
        File file = new File(PRINTER_DIR);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

