/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mobile.clientinfo;

import com.sap.mobile.clientinfo.ClientInfo;
import com.sap.mobile.clientinfo.ClientInfoCache;
import com.sap.mobile.clientinfo.DefaultClientInfo;
import com.sap.mobile.clientinfo.DeviceCapability;
import com.sap.mobile.clientinfo.DeviceConfiguration;
import com.sap.mobile.clientinfo.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class ClientInfoLoader {
    private static int MAX_HIERARCHY = 99;
    ClientInfoCache cache = ClientInfoCache.getInstance();

    public ClientInfo load(HttpServletRequest httpRequest, DefaultClientInfo clientInfo) {
        String httpAccept = httpRequest.getHeader("ACCEPT");
        String httpUserAgent = httpRequest.getHeader("USER-AGENT");
        return this.load(httpAccept, httpUserAgent, clientInfo);
    }

    public ClientInfo load(String httpAccept, String httpUserAgent, DefaultClientInfo clientInfo) {
        try {
            Util.trace(1, "loading ClientInfo data ......");
            Util.trace(1, "  ACCEPT:" + httpAccept);
            Util.trace(1, "  USER-AGENT:" + httpUserAgent);
            TreeMap<Integer, DeviceConfiguration> foundcfgs = new TreeMap<Integer, DeviceConfiguration>();
            Collection devcol = this.cache.getDevices().values();
            String deviceName = "";
            Iterator iter = devcol.iterator();
            while (iter.hasNext()) {
                DeviceConfiguration devcfg = (DeviceConfiguration)iter.next();
                if (devcfg.priority <= MAX_HIERARCHY || httpAccept.toUpperCase().indexOf(devcfg.accept) < 0) continue;
                foundcfgs.put(new Integer(devcfg.priority), devcfg);
            }
            deviceName = !foundcfgs.isEmpty() ? ((DeviceConfiguration)foundcfgs.get(foundcfgs.firstKey())).deviceName : "htmlGeneric";
            HashMap foundcaps = (HashMap)this.cache.getDevcaps().get(deviceName);
            Iterator iter2 = foundcaps.values().iterator();
            while (iter2.hasNext()) {
                DeviceCapability devcap = (DeviceCapability)iter2.next();
                clientInfo.setProperty(devcap.name, devcap.value);
                Util.trace(4, "ClientInfo: " + devcap.name + ": " + devcap.value);
            }
            foundcfgs.clear();
            devcol = this.cache.getDevices().values();
            Iterator iter3 = devcol.iterator();
            while (iter3.hasNext()) {
                DeviceConfiguration devcfg = (DeviceConfiguration)iter3.next();
                if (devcfg.priority > MAX_HIERARCHY || httpUserAgent.toUpperCase().indexOf(devcfg.userAgent) < 0) continue;
                foundcfgs.put(new Integer(devcfg.priority), devcfg);
            }
            String logmsg = "Your device has been matched to " + deviceName;
            if (!foundcfgs.isEmpty()) {
                deviceName = ((DeviceConfiguration)foundcfgs.get(foundcfgs.firstKey())).deviceName;
                logmsg = logmsg + "->" + deviceName;
                foundcaps = (HashMap)this.cache.getDevcaps().get(deviceName);
                Iterator iter4 = foundcaps.values().iterator();
                while (iter4.hasNext()) {
                    DeviceCapability devcap = (DeviceCapability)iter4.next();
                    clientInfo.setProperty(devcap.name, devcap.value);
                    Util.trace(4, "ClientInfo: " + devcap.name + ": " + devcap.value);
                }
            }
            Util.trace(1, logmsg + " ...");
            if (httpAccept != null) {
                clientInfo.setAccept(httpAccept);
            }
            clientInfo.setUserAgent(httpUserAgent);
        }
        catch (Exception exp) {
            Util.trace(1, "ClientInfoLoader::load(): Exception occurred");
            exp.printStackTrace();
        }
        return clientInfo;
    }
}

