/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mobile.clientinfo;

import com.sap.mobile.clientinfo.ClientInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;

public class ClientInfoFactory {
    static final String CONFIG_FILE = "clientinfo.properties";
    static final String DEFAULT_IMPL = "com.sap.mobile.clientinfo.DefaultClientInfo";
    static boolean isLoaded = false;

    protected ClientInfoFactory() {
        if (!isLoaded) {
            this.loadProperties();
            isLoaded = true;
        }
    }

    public static ClientInfoFactory newInstance() {
        return new ClientInfoFactory();
    }

    public ClientInfo newClientInfo() {
        String clientInfoClassName = System.getProperty("com.sap.mobile.clientinfo.ClientInfoImpl");
        if (clientInfoClassName == null) {
            clientInfoClassName = new String(DEFAULT_IMPL);
        }
        try {
            Class<?> clientInfoClass = Class.forName(clientInfoClassName);
            Constructor<?> clientInfoConstructor = clientInfoClass.getConstructor(new Class[0]);
            ClientInfo clientInfoImpl = (ClientInfo)clientInfoConstructor.newInstance(new Object[0]);
            return clientInfoImpl;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private void loadProperties() {
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/clientinfo.properties");
            props.load(in);
            in.close();
            Properties props_ori = System.getProperties();
            ((Hashtable)props).putAll(props_ori);
            System.setProperties(props);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

