/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mobile.clientinfo;

import com.sap.mobile.clientinfo.BrowserType;
import com.sap.mobile.clientinfo.ClientInfoCache;
import com.sap.mobile.clientinfo.DeviceConfiguration;
import com.sap.mobile.clientinfo.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class ClientInfoDetector {
    private static int MAX_HIERARCHY = 99;
    ClientInfoCache cache = ClientInfoCache.getInstance();

    public BrowserType detect(HttpServletRequest httpRequest) {
        String httpAccept = httpRequest.getHeader("ACCEPT");
        String httpUserAgent = httpRequest.getHeader("USER-AGENT");
        return this.detect(httpAccept, httpUserAgent);
    }

    public BrowserType detect(String httpAccept, String httpUserAgent) {
        String browserTypeString = "UNKNOWN";
        try {
            Util.trace(1, "loading ClientInfo data ......");
            Util.trace(1, "  ACCEPT:" + httpAccept);
            Util.trace(1, "  USER-AGENT:" + httpUserAgent);
            TreeMap<Integer, DeviceConfiguration> foundcfgs = new TreeMap<Integer, DeviceConfiguration>();
            Collection devcol = this.cache.getDevices().values();
            String deviceName = "";
            Iterator iter = devcol.iterator();
            while (iter.hasNext()) {
                DeviceConfiguration devcfg = (DeviceConfiguration)iter.next();
                if (devcfg.priority > MAX_HIERARCHY && httpAccept.indexOf(devcfg.accept) >= 0) {
                    foundcfgs.put(new Integer(devcfg.priority), devcfg);
                    continue;
                }
                if (devcfg.priority > MAX_HIERARCHY || httpUserAgent.toUpperCase().indexOf(devcfg.userAgent) < 0) continue;
                foundcfgs.put(new Integer(devcfg.priority), devcfg);
            }
            if (!foundcfgs.isEmpty()) {
                browserTypeString = ((DeviceConfiguration)foundcfgs.get(foundcfgs.firstKey())).browserType;
                deviceName = ((DeviceConfiguration)foundcfgs.get(foundcfgs.firstKey())).deviceName;
            }
            String logmsg = "Your device has been matched to ";
            logmsg = logmsg + deviceName + "(" + browserTypeString + ")";
            Util.trace(1, logmsg + " ...");
        }
        catch (Exception exp) {
            Util.trace(1, "ClientInfoLoader::load(): Exception occurred");
            exp.printStackTrace();
        }
        return BrowserType.valueOf(browserTypeString);
    }
}

