/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mobile.clientinfo;

import com.sap.mobile.clientinfo.DeviceCapability;
import com.sap.mobile.clientinfo.DeviceConfiguration;
import com.sap.mobile.clientinfo.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClientInfoCache {
    static ClientInfoCache instance = null;
    private HashMap devices;
    private HashMap devcaps;
    public String devFile = "devices.xml";

    public HashMap getDevices() {
        if (this.devices == null) {
            InputStream in = this.getClass().getResourceAsStream("/" + this.devFile);
            if (in != null) {
                Element docRoot = this.parseXmlFile(in);
                this.devices = new HashMap();
                this.loadDevcfgs(docRoot, this.devices);
            } else {
                System.out.println("in ist null");
            }
        }
        return this.devices;
    }

    public HashMap getDevcaps() {
        if (this.devcaps == null) {
            this.devcaps = new HashMap();
            this.loadDevcaps(this.getDevices(), this.devcaps);
        }
        return this.devcaps;
    }

    public static synchronized ClientInfoCache getInstance() {
        if (instance == null) {
            instance = new ClientInfoCache();
        }
        return instance;
    }

    public String getProperty(String deviceId, String name) {
        return "";
    }

    private ClientInfoCache() {
        int traceLevel;
        try {
            traceLevel = Integer.parseInt(System.getProperty("com.sap.mobile.clientinfo.TraceLevel"));
        }
        catch (Exception e) {
            traceLevel = 0;
        }
        Util.setTraceLevel(traceLevel);
    }

    protected Element parseXmlFile(InputStream location) {
        Document document = null;
        try {
            Util.trace(1, "Opening file " + location);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(location);
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (FactoryConfigurationError e) {
            Util.trace(1, "Please install a XMl parser");
        }
        catch (FileNotFoundException e) {
        }
        catch (SAXParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            Util.trace(1, "Lack of XML parser implementation");
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return document.getDocumentElement();
    }

    public void loadDevcfgs(Element docRoot, HashMap devices) {
        Node device = docRoot.getFirstChild();
        while (device != null) {
            if (device.getNodeType() == 1) {
                String deviceName = this.loadDevcfg(device, devices);
            }
            device = device.getNextSibling();
        }
    }

    public void loadDevcaps(HashMap devices, HashMap devcaps) {
        Iterator iter = devices.values().iterator();
        while (iter.hasNext()) {
            DeviceConfiguration devcfg = (DeviceConfiguration)iter.next();
            String deviceName = devcfg.deviceName;
            if (deviceName.length() <= 0 || devcaps.containsKey(deviceName)) continue;
            try {
                InputStream in = this.getClass().getResourceAsStream("/" + deviceName + ".cap");
                Element devcapRoot = this.parseXmlFile(in);
                HashMap caps = new HashMap();
                devcaps.put(deviceName, caps);
                this.loadDevcap(devcapRoot, caps);
                Util.trace(1, "device " + deviceName + " is loaded");
            }
            catch (Exception e) {
                Util.trace(1, "Error: Cannot load device " + deviceName + ".cap");
            }
        }
    }

    public String loadDevcfg(Node device, HashMap devices) {
        Util.trace(1, "Loading device configuration for " + this.getDeviceProp("deviceName", device) + " ...");
        DeviceConfiguration devcfg = new DeviceConfiguration();
        devcfg.id = this.getDeviceProp("id", device);
        devcfg.userAgent = this.getDeviceProp("userAgent", device).toUpperCase();
        devcfg.priority = Integer.parseInt(this.getDeviceProp("priority", device));
        devcfg.accept = this.getDeviceProp("accept", device).toUpperCase();
        devcfg.deviceName = this.getDeviceProp("deviceName", device);
        devcfg.browserType = this.getDeviceProp("browserType", device);
        devices.put(devcfg.id, devcfg);
        return devcfg.deviceName;
    }

    public void loadDevcap(Element docRoot, HashMap devcaps) {
        Node prop = docRoot.getFirstChild();
        while (prop != null) {
            if (prop.getNodeType() == 1) {
                DeviceCapability devcap = new DeviceCapability();
                devcap.name = prop.getNodeName();
                try {
                    devcap.value = prop.getFirstChild().getNodeValue();
                }
                catch (Exception e) {
                    devcap.value = "";
                }
                devcaps.put(devcap.name, devcap);
                Util.trace(4, "> Loading " + devcap.name + ": " + devcap.value + " ...");
            }
            prop = prop.getNextSibling();
        }
    }

    public String getDeviceProp(String propName, Node devNode) {
        NodeList nodes = devNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().compareTo(propName) == 0) {
                if (node.hasChildNodes()) {
                    return node.getFirstChild().getNodeValue();
                }
                return "";
            }
            ++i;
        }
        return "";
    }
}

