/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class UrlUtil {
    public static IPath getTrailingPath(URL fullURL, URL startingURL) {
        Path fullPath = new Path(fullURL.getPath());
        Path startingPath = new Path(startingURL.getPath());
        int matchingCount = fullPath.matchingFirstSegments((IPath)startingPath);
        return fullPath.removeFirstSegments(matchingCount);
    }

    public static URL concat(String root, IPath end) throws MalformedURLException {
        return new URL(UrlUtil.concatString(root, end));
    }

    public static String concatString(String root, IPath end) {
        if (end.isEmpty()) {
            return root;
        }
        if (root.length() == 0) {
            return end.toString();
        }
        boolean rootHasTrailing = root.charAt(root.length() - 1) == '/';
        boolean endHasLeading = end.isAbsolute();
        if (rootHasTrailing && endHasLeading) {
            return String.valueOf(root) + end.toString().substring(1);
        }
        if (!rootHasTrailing && !endHasLeading) {
            return String.valueOf(root) + '/' + end.toString();
        }
        return String.valueOf(root) + end.toString();
    }

    public static String makeAbsolute(String url) {
        boolean hasTrailing;
        boolean bl = hasTrailing = url.charAt(url.length() - 1) == '/';
        if (hasTrailing) {
            return url;
        }
        return String.valueOf(url) + '/';
    }

    public static String toTruncatedPath(URL url, int split) {
        return UrlUtil.toTruncatedPath(url.getPath(), split);
    }

    public static String toTruncatedPath(String url, int split) {
        Path path = new Path(url);
        int segments = (path = path.setDevice(null)).segmentCount();
        if (segments > split) {
            IPath last = path.removeFirstSegments(segments - split);
            return ".../" + last.toString();
        }
        return path.toString();
    }
}

