/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.ITargetRunnable;
import org.eclipse.team.internal.core.target.Site;

public abstract class TargetProvider {
    public abstract Site getSite();

    public abstract URL getURL();

    public abstract void get(IResource[] var1, IProgressMonitor var2) throws TeamException;

    public abstract void get(IResource var1, IRemoteTargetResource var2, IProgressMonitor var3) throws TeamException;

    public abstract void put(IResource[] var1, IProgressMonitor var2) throws TeamException;

    public abstract IRemoteTargetResource getRemoteResourceFor(IResource var1);

    public abstract IRemoteTargetResource getRemoteResource();

    public boolean canGet(IResource resource) {
        return true;
    }

    public boolean canPut(IResource resource) {
        return true;
    }

    public abstract boolean isOutOfDate(IResource var1, IProgressMonitor var2) throws TeamException;

    public abstract boolean isDirty(IResource var1);

    public abstract boolean hasBase(IResource var1);

    public abstract void deregister(IProject var1);

    public void run(final ITargetRunnable runnable, IProgressMonitor monitor) throws TeamException {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        runnable.run(monitor);
                    }
                    catch (TeamException e) {
                        throw new CoreException(e.getStatus());
                    }
                }
            }, monitor);
        }
        catch (CoreException e) {
            throw new TeamException(e.getStatus());
        }
    }

    public abstract IRemoteSyncElement getRemoteSyncElement(IResource var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            return this.getURL().toExternalForm().equals(((TargetProvider)obj).getURL().toExternalForm());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getURL().toExternalForm().hashCode();
    }
}

