/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.target.ISiteFactory;
import org.eclipse.team.internal.core.target.ISiteListener;
import org.eclipse.team.internal.core.target.LocationMapping;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetProvider;

public class TargetManager {
    private static final String TARGET_SITES_FILE = ".targetSites";
    private static final QualifiedName TARGET_MAPPINGS = new QualifiedName("org.eclipse.team.core.target", "mappings");
    private static Map factories = new Hashtable();
    private static List sites = new ArrayList();
    private static List listeners = new ArrayList();
    private static final QualifiedName PROP_KEY = new QualifiedName("org.eclipse.team", "target");
    private static final String BASIC_TARGET_KEY = "basic";

    public static void startup() {
        ResourcesPlugin.getWorkspace().getSynchronizer().add(TARGET_MAPPINGS);
        TargetManager.readLocations();
    }

    public static Site[] getSites() {
        return sites.toArray(new Site[sites.size()]);
    }

    public static void addSite(Site site) {
        sites.add(site);
        TargetManager.save();
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ISiteListener element = (ISiteListener)it.next();
            element.siteAdded(site);
        }
    }

    public static void removeSite(Site site) {
        sites.remove(site);
        TargetManager.save();
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ISiteListener element = (ISiteListener)it.next();
            element.siteRemoved(site);
        }
    }

    public static void map(IProject project, Site site, IPath path) throws TeamException {
        try {
            ISynchronizer s = ResourcesPlugin.getWorkspace().getSynchronizer();
            byte[] mappingBytes = s.getSyncInfo(TARGET_MAPPINGS, (IResource)project);
            if (mappingBytes != null) {
                throw new TeamException(Policy.bind("TargetManager.Problems_mapping_project._Project_is_already_mapped._4"));
            }
            LocationMapping mapping = new LocationMapping(site, path);
            s.setSyncInfo(TARGET_MAPPINGS, (IResource)project, mapping.encode());
            project.setPersistentProperty(PROP_KEY, BASIC_TARGET_KEY);
        }
        catch (CoreException e) {
            throw new TeamException(Policy.bind("TargetManager.Problems_mapping_project", project.getName()), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new TeamException(Policy.bind("TargetManager.Problems_mapping_project", project.getName()), e);
        }
    }

    public static void unmap(IProject project) throws TeamException {
        try {
            ISynchronizer s = ResourcesPlugin.getWorkspace().getSynchronizer();
            byte[] mappingBytes = s.getSyncInfo(TARGET_MAPPINGS, (IResource)project);
            if (mappingBytes == null) {
                throw new TeamException(Policy.bind("TargetManager.unableToUnmap", project.getName()));
            }
            TargetProvider provider = TargetManager.getProvider(project);
            provider.deregister(project);
            s.flushSyncInfo(TARGET_MAPPINGS, (IResource)project, 0);
            project.setPersistentProperty(PROP_KEY, null);
        }
        catch (CoreException e) {
            throw new TeamException(Policy.bind("TargetManager.problemsUnmapping", project.getName()), (Exception)((Object)e));
        }
    }

    public static TargetProvider getProvider(IProject project) throws TeamException {
        try {
            ISynchronizer s = ResourcesPlugin.getWorkspace().getSynchronizer();
            byte[] mappingBytes = s.getSyncInfo(TARGET_MAPPINGS, (IResource)project);
            if (mappingBytes == null) {
                return null;
            }
            LocationMapping mapping = new LocationMapping(mappingBytes);
            Site site = TargetManager.getSite(mapping.getType(), mapping.getURL());
            if (site != null) {
                return site.newProvider(mapping.getPath());
            }
            return null;
        }
        catch (CoreException e) {
            throw new TeamException(Policy.bind("TargetManager.problemsGettingProvider", project.getName()), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new TeamException(Policy.bind("TargetManager.problemsGettingProvider", project.getName()), e);
        }
    }

    public static Site getSite(String type, URL url) {
        return TargetManager.getSite(type, url.toExternalForm());
    }

    public static Site getSite(String type, String urlID) {
        Iterator it = sites.iterator();
        while (it.hasNext()) {
            Site element = (Site)it.next();
            if (!element.getType().equals(type) || !element.getURL().toExternalForm().equals(urlID)) continue;
            return element;
        }
        return null;
    }

    public static void addSiteListener(ISiteListener listener) {
        listeners.add(listener);
    }

    public static void removeSiteListener(ISiteListener listener) {
        listeners.remove(listener);
    }

    private static void readLocations() {
        IPath pluginStateLocation = TeamPlugin.getPlugin().getStateLocation().append(TARGET_SITES_FILE);
        File f = pluginStateLocation.toFile();
        if (f.exists()) {
            try {
                DataInputStream dis = new DataInputStream(new FileInputStream(f));
                TargetManager.readLocations(dis);
            }
            catch (IOException e) {
                TeamPlugin.log((IStatus)new Status(4, "org.eclipse.team.core", 0, Policy.bind("Config.error"), (Throwable)e));
            }
        }
    }

    private static void writeLocations() {
        IPath pluginStateLocation = TeamPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append(".targetSites.tmp").toFile();
        File stateFile = pluginStateLocation.append(TARGET_SITES_FILE).toFile();
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(tempFile));
            TargetManager.writeLocations(dos);
            dos.close();
            if (stateFile.exists()) {
                stateFile.delete();
            }
            boolean renamed = tempFile.renameTo(stateFile);
        }
        catch (IOException e) {
            TeamPlugin.log((IStatus)new Status(4, "org.eclipse.team.core", 0, Policy.bind("Config.error"), (Throwable)e));
        }
    }

    private static void save() {
        TargetManager.writeLocations();
    }

    private static void readLocations(DataInputStream dis) throws IOException {
        int repoCount = dis.readInt();
        int i = 0;
        while (i < repoCount) {
            String id = dis.readUTF();
            ISiteFactory factory = TargetManager.getSiteFactory(id);
            if (factory == null) {
                return;
            }
            Site site = factory.newSite(new ObjectInputStream(dis));
            sites.add(site);
            ++i;
        }
    }

    private static void writeLocations(DataOutputStream dos) throws IOException {
        dos.writeInt(sites.size());
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            Site site = (Site)iter.next();
            dos.writeUTF(site.getType());
            site.writeObject(new ObjectOutputStream(dos));
        }
        dos.flush();
        dos.close();
    }

    public static ISiteFactory getSiteFactory(String id) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("targets")) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String extensionId = configElements[j].getAttribute("id");
                    if (extensionId != null && extensionId.equals(id)) {
                        try {
                            return (ISiteFactory)configElements[j].createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            TeamPlugin.log(e.getStatus());
                            return null;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }
}

