/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.ITargetRunnable;
import org.eclipse.team.internal.core.target.RemoteTargetSyncElement;
import org.eclipse.team.internal.core.target.ResourceState;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.core.target.UrlUtil;

public abstract class SynchronizedTargetProvider
extends TargetProvider {
    private static final int CONFIG_FORMAT_VERSION = 2;
    protected Site site;
    protected IPath intrasitePath;
    protected URL targetURL;

    protected static final ISynchronizer getSynchronizer() {
        return ResourcesPlugin.getWorkspace().getSynchronizer();
    }

    public SynchronizedTargetProvider(Site site, IPath intrasitePath) throws TeamException {
        this.intrasitePath = intrasitePath;
        this.site = site;
        String root = this.getSite().getURL().toExternalForm();
        try {
            this.targetURL = UrlUtil.concat(root, intrasitePath);
        }
        catch (MalformedURLException e) {
            throw new TeamException(Policy.bind(Policy.bind("SynchronizedTargetProvider.invalidURLCombination"), root, intrasitePath.toString()), e);
        }
    }

    public abstract ResourceState newState(IResource var1);

    public abstract ResourceState newState(IResource var1, IRemoteTargetResource var2);

    public Site getSite() {
        return this.site;
    }

    public URL getURL() {
        return this.targetURL;
    }

    public ResourceState getState(IResource resource) throws TeamException {
        ResourceState state = this.newState(resource);
        state.loadState();
        return state;
    }

    public ResourceState getState(IResource resource, IRemoteTargetResource remote) throws TeamException {
        ResourceState state = this.newState(resource, remote);
        state.loadState();
        return state;
    }

    public void get(final IResource[] resources, IProgressMonitor progress) throws TeamException {
        this.run(new ITargetRunnable(){

            public void run(IProgressMonitor monitor) throws TeamException {
                monitor = Policy.monitorFor(monitor);
                try {
                    monitor.beginTask(null, resources.length * 100);
                    int i = 0;
                    while (i < resources.length) {
                        SynchronizedTargetProvider.this.getState(resources[i]).get(2, Policy.subMonitorFor(monitor, 100));
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        }, Policy.monitorFor(progress));
    }

    public void get(final IResource resource, final IRemoteTargetResource remote, IProgressMonitor progress) throws TeamException {
        this.run(new ITargetRunnable(){

            public void run(IProgressMonitor monitor) throws TeamException {
                SynchronizedTargetProvider.this.getState(resource, remote).get(2, monitor);
            }
        }, Policy.monitorFor(progress));
    }

    public void put(final IResource[] resources, IProgressMonitor progress) throws TeamException {
        this.run(new ITargetRunnable(){

            public void run(IProgressMonitor monitor) throws TeamException {
                monitor = Policy.monitorFor(monitor);
                try {
                    monitor.beginTask(null, resources.length * 100);
                    int i = 0;
                    while (i < resources.length) {
                        SynchronizedTargetProvider.this.getState(resources[i]).put(Policy.subMonitorFor(monitor, 100));
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        }, Policy.monitorFor(progress));
    }

    public boolean isDirty(IResource resource) {
        try {
            return this.getState(resource).isDirty();
        }
        catch (TeamException e) {
            TeamPlugin.log(e.getStatus());
            return true;
        }
    }

    public boolean isOutOfDate(IResource resource, IProgressMonitor monitor) throws TeamException {
        ResourceState state = this.getState(resource);
        return state.isOutOfDate(monitor);
    }

    public void deregister(IProject project) {
        try {
            this.newState((IResource)project).removeState();
        }
        catch (TeamException e) {
            TeamPlugin.log(e.getStatus());
        }
    }

    public IRemoteSyncElement getRemoteSyncElement(IResource resource) {
        return new RemoteTargetSyncElement(this, resource, this.getRemoteResourceFor(resource));
    }

    public boolean hasBase(IResource resource) {
        if (resource.getType() == 4) {
            return true;
        }
        try {
            return this.getState(resource).hasPhantom();
        }
        catch (TeamException e) {
            TeamPlugin.log(e.getStatus());
            return true;
        }
    }
}

