/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.TargetProvider;

public abstract class Site {
    private URL rootUrl;

    public abstract TargetProvider newProvider(IPath var1) throws TeamException;

    public abstract String getType();

    public String getDisplayName() {
        return this.getURL().toExternalForm();
    }

    public abstract void writeObject(ObjectOutputStream var1);

    public IRemoteTargetResource getRemoteResource() throws TeamException {
        return this.newProvider((IPath)Path.EMPTY).getRemoteResource();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Site)) {
            return false;
        }
        Site location = (Site)other;
        if (!this.getType().equals(location.getType())) {
            return false;
        }
        URL url = this.getURL();
        if (url == null) {
            return super.equals(other);
        }
        return url.equals(location.getURL());
    }

    public int hashCode() {
        URL url = this.getURL();
        if (url == null) {
            return super.hashCode();
        }
        return url.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public abstract void dispose() throws TeamException;

    public URL getURL() {
        return this.rootUrl;
    }

    protected void setURL(URL rootUrl) {
        this.rootUrl = rootUrl;
    }

    public abstract Properties getConfiguration();
}

