/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.NullSubProgressMonitor;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.target.BaseIdentifierNotInitializedException;
import org.eclipse.team.internal.core.target.ITeamStatusConstants;
import org.eclipse.team.internal.core.target.SynchronizedTargetProvider;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;

public abstract class ResourceState {
    private static final int BYTES_FORMAT = 0;
    protected static final long EMPTY_LOCALBASETS = -1L;
    protected static final String EMPTY_REMOTEBASEID = "Undefined:";
    protected long localBaseTimestamp = -1L;
    protected String remoteBaseIdentifier = "Undefined:";
    protected boolean checkedOut = true;
    protected IResource localResource;
    protected QualifiedName stateKey = new QualifiedName("org.eclipse.team.target", "state_info");
    protected URL rootUrl;

    public ResourceState(IResource localResource, URL rootUrl) {
        this.rootUrl = rootUrl;
        SynchronizedTargetProvider.getSynchronizer().add(this.stateKey);
        this.localResource = localResource;
    }

    public long getLocalBaseTimestamp() throws BaseIdentifierNotInitializedException {
        if (this.localBaseTimestamp == -1L) {
            throw new BaseIdentifierNotInitializedException();
        }
        return this.localBaseTimestamp;
    }

    public String getRemoteBaseIdentifier() throws BaseIdentifierNotInitializedException {
        if (this.remoteBaseIdentifier.equals(EMPTY_REMOTEBASEID)) {
            throw new BaseIdentifierNotInitializedException();
        }
        return this.remoteBaseIdentifier;
    }

    public abstract String getReleasedIdentifier(IProgressMonitor var1) throws TeamException;

    public void checkout(IProgressMonitor progress) throws TeamException {
        progress.beginTask(null, 100);
        try {
            if (this.isOutOfDate(Policy.subMonitorFor(progress, 50))) {
                throw new TeamException(ITeamStatusConstants.CONFLICT_STATUS);
            }
            if (!this.hasRemote(Policy.subMonitorFor(progress, 50))) {
                throw new TeamException(ITeamStatusConstants.NO_REMOTE_RESOURCE_STATUS);
            }
            if (this.isCheckedOut()) {
                throw new TeamException(ITeamStatusConstants.NOT_CHECKED_IN_STATUS);
            }
            this.basicCheckout(progress);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            progress.done();
            throw throwable;
        }
        Object var2_4 = null;
        progress.done();
    }

    protected void basicCheckout(IProgressMonitor progress) throws TeamException {
        this.checkedOut = true;
    }

    public void checkin(IProgressMonitor progress) throws TeamException {
        progress = Policy.monitorFor(progress);
        progress.beginTask(null, 100);
        try {
            if (!this.isCheckedOut()) {
                throw new TeamException(ITeamStatusConstants.NOT_CHECKED_OUT_STATUS);
            }
            if (!this.hasLocal()) {
                if (this.hasRemote(Policy.subMonitorFor(progress, 10))) {
                    this.delete(Policy.subMonitorFor(progress, 80));
                }
            } else {
                this.mkRemoteDirs(Policy.subMonitorFor(progress, 10));
                if (this.getLocal().getType() == 1) {
                    this.upload(Policy.subMonitorFor(progress, 80));
                }
            }
            this.checkedOut = false;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            progress.done();
            throw throwable;
        }
        Object var2_4 = null;
        progress.done();
    }

    public void uncheckout(IProgressMonitor progress) throws TeamException {
        if (!this.isCheckedOut()) {
            throw new TeamException(ITeamStatusConstants.NOT_CHECKED_OUT_STATUS);
        }
        this.checkedOut = false;
    }

    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    public boolean isDirty() {
        if (!this.hasPhantom()) {
            return false;
        }
        if (!this.hasLocal()) {
            return true;
        }
        if (this.localBaseTimestamp == -1L) {
            return this.localResource.getType() == 1;
        }
        return this.localBaseTimestamp != this.localResource.getModificationStamp();
    }

    public boolean isOutOfDate(IProgressMonitor monitor) throws TeamException {
        if (!this.hasPhantom()) {
            return false;
        }
        if (this.remoteBaseIdentifier.equals(EMPTY_REMOTEBASEID)) {
            return false;
        }
        String releasedIdentifier = this.getReleasedIdentifier(monitor);
        return !this.remoteBaseIdentifier.equals(releasedIdentifier);
    }

    public abstract void download(IProgressMonitor var1) throws TeamException;

    public abstract void upload(IProgressMonitor var1) throws TeamException;

    public abstract void delete(IProgressMonitor var1) throws TeamException;

    public abstract boolean hasRemote(IProgressMonitor var1) throws TeamException;

    public abstract int getRemoteType();

    public abstract ResourceState[] getRemoteChildren(IProgressMonitor var1) throws TeamException;

    protected abstract void mkRemoteDirs(IProgressMonitor var1) throws TeamException;

    public IResource getLocal() {
        return this.localResource;
    }

    protected File getLocalFile() {
        return this.localResource.getLocation().toFile();
    }

    protected boolean hasLocal() {
        return this.localResource.exists();
    }

    protected boolean hasPhantom() {
        try {
            return SynchronizedTargetProvider.getSynchronizer().getSyncInfo(this.stateKey, this.localResource) != null;
        }
        catch (CoreException e) {
            TeamPlugin.log(e.getStatus());
            return false;
        }
    }

    public final void loadState() throws TeamException {
        try {
            byte[] storedState = SynchronizedTargetProvider.getSynchronizer().getSyncInfo(this.stateKey, this.localResource);
            if (storedState != null) {
                this.fromBytes(storedState);
            }
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
    }

    protected void fromBytes(byte[] bytes) throws TeamException {
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(bytes));
            if (dataStream.readByte() != 0) {
                return;
            }
            this.remoteBaseIdentifier = dataStream.readUTF();
            this.localBaseTimestamp = dataStream.readLong();
        }
        catch (IOException e) {
            throw TeamPlugin.wrapException(e);
        }
    }

    public final void storeState() throws TeamException {
        try {
            SynchronizedTargetProvider.getSynchronizer().setSyncInfo(this.stateKey, this.localResource, this.toBytes());
            if (this.localResource.getType() == 4) {
                return;
            }
            IContainer parent = this.localResource.getParent();
            if (parent != null && parent.getType() != 4 && SynchronizedTargetProvider.getSynchronizer().getSyncInfo(this.stateKey, (IResource)parent) == null) {
                this.getParent().storeState();
            } else {
                ResourcesPlugin.getWorkspace().save(false, null);
            }
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
    }

    protected byte[] toBytes() throws TeamException {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(32);
            DataOutputStream dataStream = new DataOutputStream(byteStream);
            dataStream.writeByte(0);
            dataStream.writeUTF(this.remoteBaseIdentifier);
            dataStream.writeLong(this.localBaseTimestamp);
            dataStream.close();
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw TeamPlugin.wrapException(e);
        }
    }

    public final void removeState() throws TeamException {
        try {
            if (this.localResource.exists() || this.localResource.isPhantom()) {
                SynchronizedTargetProvider.getSynchronizer().flushSyncInfo(this.stateKey, this.localResource, 2);
            }
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public URL getRoot() {
        return this.rootUrl;
    }

    private ResourceState getParent() throws TeamException {
        return this.getResourceStateFor((IResource)this.localResource.getParent());
    }

    private ResourceState getResourceStateFor(IResource resource) throws TeamException {
        TargetProvider provider = TargetManager.getProvider(resource.getProject());
        return ((SynchronizedTargetProvider)provider).getState(resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void get(int depth, IProgressMonitor progress) throws TeamException {
        block18: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                progress = Policy.monitorFor(progress);
                                NullSubProgressMonitor noProgress = new NullSubProgressMonitor(progress);
                                try {
                                    progress.beginTask(null, 100);
                                    Policy.checkCanceled(progress);
                                    if (!this.hasRemote((IProgressMonitor)noProgress)) {
                                        if (this.hasLocal()) {
                                            this.deleteLocal((IProgressMonitor)noProgress);
                                        }
                                        Object var4_4 = null;
                                        break block13;
                                    }
                                    if (!this.hasLocal()) {
                                        this.mkLocalDirs((IProgressMonitor)noProgress);
                                    }
                                    if (this.getRemoteType() == 1) {
                                        this.download(Policy.subMonitorFor(progress, 100));
                                        break block14;
                                    }
                                    if (this.getLocal().getType() == 1) {
                                        if (this.hasLocal()) {
                                            this.deleteLocal((IProgressMonitor)noProgress);
                                        }
                                        this.localResource = this.localResource.getParent().getFolder((IPath)new Path(this.localResource.getName()));
                                        this.mkLocalDirs((IProgressMonitor)noProgress);
                                    }
                                    switch (depth) {
                                        case 0: {
                                            break block15;
                                        }
                                        case 1: {
                                            this.getFolderShallow(Policy.subMonitorFor(progress, 100));
                                            break block16;
                                        }
                                        case 2: {
                                            this.getFolderDeep(Policy.subMonitorFor(progress, 100));
                                            break block17;
                                        }
                                        default: {
                                            Assert.isLegal(false);
                                            break;
                                        }
                                    }
                                    break block18;
                                }
                                catch (Throwable throwable) {
                                    Object var4_10 = null;
                                    progress.done();
                                    throw throwable;
                                }
                            }
                            progress.done();
                            return;
                        }
                        Object var4_5 = null;
                        progress.done();
                        return;
                    }
                    Object var4_6 = null;
                    progress.done();
                    return;
                }
                Object var4_7 = null;
                progress.done();
                return;
            }
            Object var4_8 = null;
            progress.done();
            return;
        }
        Object var4_9 = null;
        progress.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void getFolderDeep(IProgressMonitor progress) throws TeamException {
        block7: {
            block6: {
                progress = Policy.monitorFor(progress);
                try {
                    progress.beginTask(null, 10);
                    ResourceState[] childFolders = this.getFolderShallow(Policy.subMonitorFor(progress, 7));
                    if (childFolders.length == 0) {
                        Object var7_3 = null;
                        break block6;
                    }
                    IProgressMonitor subProgress = Policy.subMonitorFor(progress, 3);
                    try {
                        subProgress.beginTask(null, childFolders.length);
                        int i = 0;
                        while (i < childFolders.length) {
                            childFolders[i].get(2, Policy.subMonitorFor(subProgress, 1));
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        subProgress.done();
                        throw throwable;
                    }
                    Object var5_10 = null;
                    subProgress.done();
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    progress.done();
                    throw throwable;
                }
            }
            progress.done();
            return;
        }
        Object var7_4 = null;
        progress.done();
    }

    protected final ResourceState[] getFolderShallow(IProgressMonitor progress) throws TeamException {
        ResourceState[] resourceStateArray;
        progress = Policy.monitorFor(progress);
        NullProgressMonitor noProgress = new NullProgressMonitor();
        try {
            Assert.isLegal(this.getLocal() instanceof IContainer);
            IContainer localContainer = (IContainer)this.getLocal();
            ResourceState[] remoteChildren = this.getRemoteChildren((IProgressMonitor)noProgress);
            HashSet<ResourceState> remoteChildFolders = new HashSet<ResourceState>();
            IResource[] localChildren = this.getLocalChildren();
            HashSet<IResource> surplusLocalChildren = new HashSet<IResource>(localChildren.length);
            surplusLocalChildren.addAll(Arrays.asList(localChildren));
            progress.beginTask(null, remoteChildren.length * 100);
            int i = 0;
            while (i < remoteChildren.length) {
                Policy.checkCanceled(progress);
                ResourceState remoteChildState = remoteChildren[i];
                if (remoteChildState.getRemoteType() == 1) {
                    remoteChildState.download(Policy.subMonitorFor(progress, 100));
                    surplusLocalChildren.remove(remoteChildState.getLocal());
                } else {
                    remoteChildFolders.add(remoteChildState);
                    IResource localChild = remoteChildState.getLocal();
                    if (localChild.exists() && !(localChild instanceof IContainer)) {
                        remoteChildState.deleteLocal((IProgressMonitor)noProgress);
                    }
                }
                ++i;
            }
            TargetProvider provider = TargetManager.getProvider(localContainer.getProject());
            Iterator childrenItr = surplusLocalChildren.iterator();
            while (childrenItr.hasNext()) {
                IResource unseenChild = (IResource)childrenItr.next();
                ((SynchronizedTargetProvider)provider).newState(unseenChild).deleteLocal((IProgressMonitor)noProgress);
            }
            resourceStateArray = remoteChildFolders.toArray(new ResourceState[remoteChildFolders.size()]);
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            progress.done();
            throw throwable;
        }
        progress.done();
        return resourceStateArray;
    }

    protected final void deleteLocal(IProgressMonitor progress) throws TeamException {
        try {
            this.getLocal().delete(2, progress);
            this.removeState();
        }
        catch (CoreException exception) {
            throw TeamPlugin.wrapException(exception);
        }
    }

    protected final void mkLocalDirs(IProgressMonitor progress) throws TeamException {
        try {
            IResource resource = this.getLocal();
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            if (resource.getType() == 2 && !resource.exists()) {
                if (!resource.getParent().exists()) {
                    ResourceState parent = this.getResourceStateFor((IResource)resource.getParent());
                    parent.mkLocalDirs(progress);
                }
                ((IFolder)resource).create(false, true, progress);
                this.storeState();
            }
        }
        catch (CoreException exception) {
            throw TeamPlugin.wrapException(exception);
        }
    }

    protected final IResource[] getLocalChildren() throws TeamException {
        Assert.isLegal(this.getLocal() instanceof IContainer);
        IContainer container = (IContainer)this.getLocal();
        if (container.exists()) {
            try {
                return container.members();
            }
            catch (CoreException exception) {
                throw TeamPlugin.wrapException(exception);
            }
        }
        return new IResource[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void put(IProgressMonitor progress) throws TeamException {
        block14: {
            block13: {
                block12: {
                    progress = Policy.monitorFor(progress);
                    NullSubProgressMonitor noProgress = new NullSubProgressMonitor(progress);
                    try {
                        progress.beginTask(null, 100);
                        Policy.checkCanceled(progress);
                        this.checkin(Policy.subMonitorFor(progress, 75));
                        if (this.localResource.getType() == 1) {
                            Object var12_3 = null;
                            break block12;
                        }
                        if (!this.hasLocal()) {
                            break block13;
                        }
                        HashMap<IResource, ResourceState> surplusRemoteChildren = new HashMap<IResource, ResourceState>();
                        boolean hasRemote = this.hasRemote((IProgressMonitor)noProgress);
                        if (hasRemote) {
                            ResourceState[] remoteChildren = this.getRemoteChildren(progress);
                            int i = 0;
                            while (i < remoteChildren.length) {
                                ResourceState resourceState = remoteChildren[i];
                                surplusRemoteChildren.put(resourceState.getLocal(), resourceState);
                                ++i;
                            }
                        }
                        IResource[] localChildren = this.getLocalChildren();
                        IProgressMonitor subMonitor = Policy.subMonitorFor(progress, 25);
                        try {
                            subMonitor.beginTask(null, localChildren.length * 100);
                            int i = 0;
                            while (i < localChildren.length) {
                                IResource localChild = localChildren[i];
                                ResourceState state = (ResourceState)surplusRemoteChildren.get(localChild);
                                if (state == null) {
                                    state = this.getResourceStateFor(localChild);
                                } else {
                                    surplusRemoteChildren.remove(localChild);
                                }
                                state.put(Policy.subMonitorFor(subMonitor, 100));
                                ++i;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_18 = null;
                            subMonitor.done();
                            throw throwable;
                        }
                        Object var10_19 = null;
                        subMonitor.done();
                        Iterator childrenItr = surplusRemoteChildren.values().iterator();
                        while (childrenItr.hasNext()) {
                            ResourceState unseenChild = (ResourceState)childrenItr.next();
                            unseenChild.delete((IProgressMonitor)noProgress);
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var12_5 = null;
                        progress.done();
                        throw throwable;
                    }
                }
                progress.done();
                return;
            }
            Object var12_4 = null;
            progress.done();
            return;
        }
        Object var12_6 = null;
        progress.done();
    }

    protected void setRemoteBaseIdentifier(String remoteBaseIdentifier) {
        this.remoteBaseIdentifier = remoteBaseIdentifier;
    }

    public void setLocalBaseTimestamp(long localBaseTimestamp) {
        this.localBaseTimestamp = localBaseTimestamp;
    }
}

