/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.ILocalSyncElement;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.core.sync.RemoteSyncElement;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.TargetProvider;

public class RemoteTargetSyncElement
extends RemoteSyncElement {
    private IRemoteTargetResource remote;
    private IResource local;
    private TargetProvider provider;

    public RemoteTargetSyncElement(TargetProvider provider, IResource local, IRemoteTargetResource remote) {
        this.local = local;
        this.remote = remote;
        this.provider = provider;
    }

    public IRemoteSyncElement create(boolean isThreeWay, IResource local, IRemoteResource base, IRemoteResource remote, Object data) {
        return new RemoteTargetSyncElement(this.provider, local, (IRemoteTargetResource)remote);
    }

    protected boolean timestampEquals(IResource e1, IRemoteResource e2) {
        return false;
    }

    protected boolean timestampEquals(IRemoteResource e1, IRemoteResource e2) {
        return false;
    }

    public ILocalSyncElement create(IResource local, IRemoteResource base, Object data) {
        return new RemoteTargetSyncElement(this.provider, local, (IRemoteTargetResource)base);
    }

    protected Object getData() {
        return null;
    }

    protected boolean isIgnored(IResource resource) {
        return false;
    }

    public IRemoteResource getRemote() {
        return this.remote;
    }

    public boolean isThreeWay() {
        return true;
    }

    public IResource getLocal() {
        return this.local;
    }

    public IRemoteResource getBase() {
        return null;
    }

    public int getSyncKind(int granularity, IProgressMonitor progress) {
        boolean isIncoming;
        boolean isOutgoing;
        progress.beginTask(null, 100);
        int description = 0;
        IResource local = this.getLocal();
        boolean localExists = local.exists();
        boolean hasBase = this.provider.hasBase(local);
        if (hasBase) {
            isOutgoing = this.provider.isDirty(local);
            isIncoming = this.isOutOfDate(Policy.subMonitorFor(progress, 10));
        } else {
            isOutgoing = localExists;
            boolean bl = isIncoming = this.remote != null;
        }
        if (this.remote == null) {
            if (localExists) {
                if (!isOutgoing && isIncoming) {
                    description = 10;
                } else if (isOutgoing && isIncoming) {
                    description = 15;
                } else if (!isOutgoing && !isIncoming) {
                    description = 5;
                } else if (isOutgoing && !isIncoming) {
                    description = 5;
                }
            }
        } else if (!localExists) {
            if (!isOutgoing) {
                description = 9;
            } else if (isOutgoing && !isIncoming) {
                description = 6;
            } else if (isOutgoing && isIncoming) {
                description = 15;
            }
        } else {
            if (isOutgoing || isIncoming) {
                description = !isOutgoing && isIncoming ? 11 : (isOutgoing && !isIncoming ? 7 : 15);
            }
            if (description != 0 && this.compare(granularity, false, local, (IRemoteResource)this.remote, Policy.subMonitorFor(progress, 90))) {
                description |= 0x10;
            }
        }
        return description;
    }

    protected TargetProvider getProvider() {
        return this.provider;
    }

    protected boolean isOutOfDate(IProgressMonitor monitor) {
        IResource local = this.getLocal();
        if (this.provider.hasBase(local)) {
            try {
                return this.provider.isOutOfDate(local, monitor);
            }
            catch (TeamException e) {
                TeamPlugin.log(e.getStatus());
                return true;
            }
        }
        return false;
    }
}

