/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.core.target.Site;

public class LocationMapping {
    private final long SERIAL_ID = 1L;
    private String type;
    private URL url;
    private IPath path;

    public LocationMapping(Site site, IPath path) {
        this.type = site.getType();
        this.url = site.getURL();
        this.path = path;
    }

    public LocationMapping(String type, URL url, IPath path) {
        this.type = type;
        this.url = url;
        this.path = path;
    }

    public LocationMapping(byte[] bytes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream is = new DataInputStream(bis);
        is.readLong();
        this.type = is.readUTF();
        this.url = new URL(is.readUTF());
        this.path = new Path(is.readUTF());
    }

    public String getType() {
        return this.type;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocationMapping)) {
            return false;
        }
        LocationMapping location = (LocationMapping)other;
        return this.getType().equals(location.getType()) && this.getURL().equals(location.getURL()) && this.getPath().equals((Object)location.getPath());
    }

    public IPath getPath() {
        return this.path;
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(bos);
        os.writeLong(1L);
        os.writeUTF(this.getType());
        os.writeUTF(this.getURL().toExternalForm());
        os.writeUTF(this.getPath().toString());
        return bos.toByteArray();
    }
}

