/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.target;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.target.Site;

public abstract class AuthenticatedSite
extends Site {
    protected String username;
    protected String password;

    public void dispose() throws TeamException {
        try {
            Platform.flushAuthorizationInfo((URL)this.getURL(), (String)"", (String)"");
        }
        catch (CoreException e) {
            throw new TeamException(e.getStatus());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String name) throws TeamException {
        HashMap<String, String> authInfo = Platform.getAuthorizationInfo((URL)this.getURL(), (String)"", (String)"");
        if (authInfo == null) {
            authInfo = new HashMap<String, String>(2);
        }
        authInfo.put("name", name);
        try {
            Platform.flushAuthorizationInfo((URL)this.getURL(), (String)"", (String)"");
            Platform.addAuthorizationInfo((URL)this.getURL(), (String)"", (String)"", authInfo);
            this.username = name;
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
    }

    public void setPassword(String password) throws TeamException {
        HashMap<String, String> authInfo = Platform.getAuthorizationInfo((URL)this.getURL(), (String)"", (String)"");
        if (authInfo == null) {
            authInfo = new HashMap<String, String>(2);
        }
        authInfo.put("password", password);
        try {
            Platform.flushAuthorizationInfo((URL)this.getURL(), (String)"", (String)"");
            Platform.addAuthorizationInfo((URL)this.getURL(), (String)"", (String)"", authInfo);
            this.password = password;
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
    }
}

