/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;

public class PollingInputStream
extends FilterInputStream {
    private static final boolean DEBUG = Policy.DEBUG_STREAMS;
    private int numAttempts;
    private IProgressMonitor monitor;

    public PollingInputStream(InputStream in, int numAttempts, IProgressMonitor monitor) {
        super(in);
        this.numAttempts = numAttempts;
        this.monitor = monitor;
    }

    public void close() throws IOException {
        int attempts = 0;
        try {
            try {
                this.readPendingInput();
            }
            catch (IOException e) {
                TeamPlugin.log((IStatus)new Status(4, "org.eclipse.team.core", 0, e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {}
        while (true) {
            try {
                this.in.close();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingInputStream.closeTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("close retry=" + attempts);
                continue;
            }
            break;
        }
    }

    public int read() throws IOException {
        int attempts = 0;
        while (true) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read();
            }
            catch (InterruptedIOException interruptedIOException) {
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingInputStream.readTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read(buffer, off, len);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred != 0) {
                    return e.bytesTransferred;
                }
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingInputStream.readTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    public long skip(long count) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.skip(count);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred != 0) {
                    return e.bytesTransferred;
                }
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingInputStream.readTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    protected void readPendingInput() throws IOException {
        int available;
        byte[] buffer = new byte[2048];
        while ((available = this.in.available()) >= 1) {
            if (available > buffer.length) {
                available = buffer.length;
            }
            if (this.in.read(buffer, 0, available) >= 1) continue;
            break;
        }
    }
}

