/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.target.TargetManager;

public final class TeamPlugin
extends Plugin {
    public static final String ID = "org.eclipse.team.core";
    public static final String PROVIDER_EXTENSION = "repository-provider-type";
    public static final String FILE_TYPES_EXTENSION = "fileTypes";
    public static final String IGNORE_EXTENSION = "ignore";
    public static final String PROJECT_SET_EXTENSION = "projectSets";
    public static final String REPOSITORY_EXTENSION = "repository";
    public static final String TARGETS_EXTENSION = "targets";
    private static TeamPlugin plugin;

    public TeamPlugin(IPluginDescriptor pluginDescriptor) {
        super(pluginDescriptor);
        plugin = this;
    }

    public void startup() throws CoreException {
        Policy.localize("org.eclipse.team.internal.core.messages");
        Team.startup();
        TargetManager.startup();
    }

    public void shutdown() {
        Team.shutdown();
    }

    public static TeamPlugin getPlugin() {
        return plugin;
    }

    public static void log(int severity, String message, Throwable e) {
        plugin.getLog().log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static TeamException wrapException(Exception e) {
        return new TeamException((IStatus)new Status(4, ID, 0, e.getMessage() != null ? e.getMessage() : "", (Throwable)e));
    }

    public static TeamException wrapException(CoreException e) {
        IStatus status = e.getStatus();
        return new TeamException((IStatus)new Status(status.getSeverity(), ID, status.getCode(), status.getMessage(), (Throwable)e));
    }
}

