/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.core.Policy;

public class DefaultFileModificationValidator
implements IFileModificationValidator {
    private static final Status OK = Team.OK_STATUS;

    private IStatus getDefaultStatus(IFile file) {
        return file.isReadOnly() ? new Status(4, "org.eclipse.team.core", 4, Policy.bind("FileModificationValidator.fileIsReadOnly", file.getFullPath().toString()), null) : OK;
    }

    public IStatus validateEdit(IFile[] files, Object context) {
        if (files.length == 1) {
            return this.getDefaultStatus(files[0]);
        }
        Status[] stati = new Status[files.length];
        boolean allOK = true;
        int i = 0;
        while (i < files.length) {
            stati[i] = this.getDefaultStatus(files[i]);
            if (!stati[i].isOK()) {
                allOK = false;
            }
            ++i;
        }
        return new MultiStatus("org.eclipse.team.core", 0, (IStatus[])stati, Policy.bind(allOK ? "FileModificationValidator.ok" : "FileModificationValidator.someReadOnly"), null);
    }

    public IStatus validateSave(IFile file) {
        return this.getDefaultStatus(file);
    }
}

