/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.test;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.test.AbstractTestCall;

public class TestErrorCalls
extends AbstractTestCall {
    public void test_invalidMethod() {
        this.clear();
        this.addNOP();
        RpeMethod m1 = this.m_o1.createMethod("METHOD1_ERR");
        this.m_o1.callMethod(m1);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m1.getName(), null, null);
    }

    public void test_invalidParameter() {
        this.clear();
        this.addNOP();
        RpeMethod m1 = this.m_o1.createMethod("METHOD1");
        IEdoAtomicValue v0 = this.m_context.createValue("ERROR");
        m1.addImportingParameter("PARAM_ERR", "STRING", RpeParameterMeta.Atomic, (IEdoValue)v0);
        this.m_o1.callMethod(m1);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m1.getName(), null, null);
    }

    public void test_invalidInputParameterType() {
        this.clear();
        this.addNOP();
        RpeMethod m2 = this.m_o1.createMethod("METHOD2");
        IEdoAtomicValue v1 = this.m_context.createValue("A simple parameter");
        RpeParameter p1 = this.m_context.createParameter("PARAMETER1", "ERR_STRING", RpeParameterKind.Importing, RpeParameterMeta.Atomic, (IEdoValue)v1);
        m2.addParameter(p1);
        this.m_o1.callMethod(m2);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CPF", this.m_o1.getName(), "SAMPLE_CLASS_1", m2.getName(), p1.getName(), null);
    }

    public void test_wrongInput_differentParameterType() {
        this.clear();
        this.addNOP();
        RpeMethod m2 = this.m_o1.createMethod("METHOD2");
        IEdoAtomicValue v1 = this.m_context.createValue("100");
        m2.addImportingParameter("PARAMETER1", "INT4", RpeParameterMeta.Atomic, (IEdoValue)v1);
        this.m_o1.callMethod(m2);
        this.flush();
        this.addNOP();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m2.getName(), null, null);
    }

    public void test_wrongInParameterKind_Exp4Imp() {
        this.clear();
        this.addNOP();
        RpeMethod m2 = this.m_o1.createMethod("METHOD2");
        IEdoAtomicValue v1 = this.m_context.createValue("100");
        m2.addExportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)v1);
        this.m_o1.callMethod(m2);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m2.getName(), null, null);
    }

    public void test_wrongInParameterKind_Imp4Ret() {
        this.clear();
        this.addNOP();
        RpeMethod m4 = this.m_o1.createMethod("METHOD4");
        IEdoAtomicValue v2 = this.m_context.createValue("Need to be changed");
        m4.addImportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)v2);
        this.m_o1.callMethod(m4);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m4.getName(), null, null);
    }

    public void test_wrongInParameterMeta_Table4Simple() {
        this.clear();
        this.addNOP();
        RpeMethod m2 = this.m_o1.createMethod("METHOD2");
        IEdoAtomicValue v1 = this.m_context.createValue("100");
        m2.addImportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Table, (IEdoValue)v1);
        this.m_o1.callMethod(m2);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m2.getName(), null, null);
    }

    public void test_wrongInParameterMeta_Structure4Simple() {
        this.clear();
        this.addNOP();
        RpeMethod m2 = this.m_o1.createMethod("METHOD2");
        IEdoAtomicValue v1 = this.m_context.createValue("100");
        m2.addImportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Structure, (IEdoValue)v1);
        this.m_o1.callMethod(m2);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m2.getName(), null, null);
    }

    public void test_withoutReqArgument() {
        this.clear();
        this.addNOP();
        RpeMethod m2 = this.m_o1.createMethod("METHOD2");
        this.m_o1.callMethod(m2);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m2.getName(), null, null);
    }

    public void test_nullObjectMethod() {
        this.clear();
        this.addNOP2();
        RpeObject o2 = this.m_context.createObject();
        RpeMethod m1 = o2.createMethod("METHOD1");
        o2.callMethod(m1);
        this.addNOP2();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verify(this.m_context.getErrors().size() == 1, "More than one error");
        this.verifyError(0, "RPE", "RPE_ONF", o2.getName(), null, m1.getName(), "OBJECT", o2.getName());
    }

    public void test_nullObjectRelease() {
        this.clear();
        this.addNOP2();
        RpeObject o2 = this.m_context.createObject();
        o2.release();
        this.addNOP2();
        this.m_context.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verify(this.m_context.getErrors().size() == 1, "More than one error");
        this.verifyError(0, "RPE", "RPE_ONF", o2.getName(), null, null, "OBJECT", o2.getName());
    }

    public void test_invalidClass() {
        this.clear();
        this.addNOP();
        RpeObject oerr = this.m_context.createObject("CL_RSETEST_ERR");
        this.addNOP();
        this.m_context.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CNF", oerr.getName(), "CL_RSETEST_ERR", null, null, null);
    }

    public void test_wrongInput_differentStructureType() {
        this.clear();
        this.addNOP();
        RpeMethod m8 = this.m_o1.createMethod("METHOD8");
        IEdoStructure s1 = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_1);
        s1.setStringValue("FIELD1", "This is field 1 ");
        s1.setStringValue("FIELD3", "100");
        m8.addImportingParameter("PARAMETER1", this.m_structDef_2.getName(), RpeParameterMeta.Structure, (IEdoValue)s1);
        this.m_o1.callMethod(m8);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m8.getName(), null, null);
    }

    public void test_wrongInput_differentTableType() {
        this.clear();
        this.addNOP();
        RpeMethod m12 = this.m_o1.createMethod("METHOD12");
        FieldDescriptor[] fields = new FieldDescriptor[]{new FieldDescriptor("FIELD1", "STRING"), new FieldDescriptor("FIELD3", "INTEGER")};
        StructureDescriptor m_structDef = new StructureDescriptor("RPE_SAMPLE_STRUCT_1_TAB", fields);
        IEdoTable t1 = this.m_context.createTable((IStructureDescriptor)m_structDef);
        t1.append(4);
        int i = 0;
        while (i < 4) {
            t1.setStringValue(i, "FIELD1", "This is parameter " + i);
            t1.setStringValue(i, "FIELD3", String.valueOf(i));
            ++i;
        }
        m12.addImportingParameter("PARAMETER1", "RPE_SAMPLE_STRUCT_1_TAB", RpeParameterMeta.Table, (IEdoValue)t1);
        this.m_o1.callMethod(m12);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m12.getName(), null, null);
    }

    public void test_wrongOutput_diffrentStructureType() {
        this.clear();
        this.addNOP();
        RpeMethod m9 = this.m_o1.createMethod("METHOD9");
        IEdoStructure s1 = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_1);
        s1.setStringValue("FIELD1", "This is to be replaced ");
        s1.setStringValue("FIELD3", "9899");
        m9.addExportingParameter("PARAMETER1", this.m_structDef_2.getName(), RpeParameterMeta.Structure, (IEdoValue)s1);
        this.m_o1.callMethod(m9);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CRF", this.m_o1.getName(), "SAMPLE_CLASS_1", m9.getName(), "PARAMETER1", null);
    }

    public void test_wrongOutput_Table4Structure() {
        this.clear();
        this.addNOP();
        RpeMethod m9 = this.m_o1.createMethod("METHOD9");
        IEdoTable t1 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_1);
        t1.append(1);
        t1.setStringValue(0, "FIELD1", "This is to be replaced ");
        t1.setStringValue(0, "FIELD3", "9899");
        m9.addExportingParameter("PARAMETER1", this.m_structDef_1.getName(), RpeParameterMeta.Table, (IEdoValue)t1);
        this.m_o1.callMethod(m9);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m9.getName(), null, null);
    }

    public void test_wrongOutput_TableWithStructureMeta() {
        this.clear();
        this.addNOP();
        RpeMethod m9 = this.m_o1.createMethod("METHOD9");
        IEdoTable t1 = this.m_context.createTable((IStructureDescriptor)this.m_structDef_1);
        t1.append(1);
        t1.setStringValue(0, "FIELD1", "This is to be replaced ");
        t1.setStringValue(0, "FIELD3", "9899");
        m9.addExportingParameter("PARAMETER1", this.m_structDef_1.getName(), RpeParameterMeta.Structure, (IEdoValue)t1);
        this.m_o1.callMethod(m9);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CRF", this.m_o1.getName(), "SAMPLE_CLASS_1", m9.getName(), "PARAMETER1", null);
    }

    public void test_wrongOutput_StrucuteWithTableMeta() {
        this.clear();
        this.addNOP();
        RpeMethod m9 = this.m_o1.createMethod("METHOD9");
        IEdoStructure s1 = this.m_context.createStructure((IStructureDescriptor)this.m_structDef_1);
        s1.setStringValue("FIELD1", "This is to be replaced ");
        s1.setStringValue("FIELD3", "9899");
        m9.addExportingParameter("PARAMETER1", this.m_structDef_1.getName(), RpeParameterMeta.Table, (IEdoValue)s1);
        this.m_o1.callMethod(m9);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m9.getName(), null, null);
    }

    public void test_wrongInput_differentStructureTypeForAny() {
        this.clear();
        this.addNOP();
        RpeMethod m15 = this.m_o1.createMethod("METHOD15");
        FieldDescriptor[] fields = new FieldDescriptor[]{new FieldDescriptor("FIELD1", "STRING"), new FieldDescriptor("FIELD3", "INTEGER")};
        StructureDescriptor m_structDef = new StructureDescriptor("FBSTRUCTURE2", fields);
        IEdoStructure s1 = this.m_context.createStructure((IStructureDescriptor)m_structDef);
        s1.setStringValue("FIELD1", "This is field 1 ");
        s1.setStringValue("FIELD3", "100");
        m15.addImportingParameter("PARAMETER1", "RPE_SAMPLE_STRUCT_1_TAB", RpeParameterMeta.Structure, (IEdoValue)s1);
        this.m_o1.callMethod(m15);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m15.getName(), null, null);
    }

    public void test_applicationException() {
        this.clear();
        this.addNOP();
        RpeMethod m16 = this.m_context.createMethod("METHOD16");
        this.m_o1.callMethod(m16);
        this.addNOP();
        this.flush();
        this.verify(!this.noErrors(), "Method call succeeded.");
        this.verifyError(0, "BOL", AbstractTestCall.DONT_CARE, this.m_o1.getName(), "SAMPLE_CLASS_1", m16.getName(), null, null);
    }

    public void Xtest_multipleErrors() {
        this.clear();
        this.addNOP();
        RpeMethod m1 = this.m_o1.createMethod("METHOD1_ERR");
        RpeMethod m2 = this.m_o1.createMethod("METHOD2_ERR");
        RpeMethod m3 = this.m_o1.createMethod("METHOD3_ERR");
        RpeMethod m4 = this.m_o1.createMethod("METHOD4_ERR");
        this.m_o1.callMethod(m1);
        this.m_o1.callMethod(m2);
        this.m_o1.callMethod(m3);
        this.m_o1.callMethod(m4);
        this.addNOP2();
        this.flush();
        this.verify(!this.noErrors() && this.m_context.getErrors().size() == 4, "Found lesser number of errors.");
        this.verifyError(0, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m1.getName(), null, null);
        this.verifyError(1, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m2.getName(), null, null);
        this.verifyError(2, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m3.getName(), null, null);
        this.verifyError(3, "RPE", "RPE_CMF", this.m_o1.getName(), "SAMPLE_CLASS_1", m4.getName(), null, null);
    }

    protected void flush() {
        this.m_context.flush();
    }
}

