/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.test;

import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.AbstractTest;
import com.sap.tc.col.rpe.IRpeConnection;
import com.sap.tc.col.rpe.RpeContext;
import com.sap.tc.col.rpe.RpeError;
import com.sap.tc.col.rpe.RpeErrors;
import com.sap.tc.col.rpe.RpeException;
import com.sap.tc.col.rpe.RpeIllegalMethodException;
import com.sap.tc.col.rpe.RpeMethod;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameterMeta;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Properties;

public abstract class AbstractTestCall
extends AbstractTest {
    protected static final String DONT_CARE = new String("DONT_CARE");
    public static final String CLASS_01 = "SAMPLE_CLASS_1";
    public static final String CLASS_02 = "SAMPLE_CLASS_2";
    protected RpeContext m_context;
    protected RpeObject m_o1;
    protected RpeObject m_o2;
    protected RpeMethod m_nop;
    protected RpeMethod m_nop2;
    protected StructureDescriptor m_structDef_1;
    protected StructureDescriptor m_structDef_2;

    public void prepare() throws Exception {
        super.prepare();
        this.m_context = RpeContext.createContext();
        Properties connProps = new Properties();
        connProps.load(((Object)((Object)this)).getClass().getResourceAsStream(this.getParameter("connectionProperties")));
        String channel = connProps.getProperty("connection.channel");
        String locator = connProps.getProperty("connection.locator");
        String client = connProps.getProperty("connection.client");
        String user = connProps.getProperty("connection.user");
        String password = connProps.getProperty("connection.password");
        String language = connProps.getProperty("connection.language");
        IRpeConnection connection = this.m_context.createConnection(channel, true);
        connection.connect(locator, client, user, password, language);
        this.m_structDef_1 = new StructureDescriptor("RPE_SAMPLE_STRUCT_1", new FieldDescriptor[]{new FieldDescriptor("FIELD1", "STRING"), new FieldDescriptor("FIELD3", "INTEGER")});
        this.m_structDef_2 = new StructureDescriptor("RPE_SAMPLE_STRUCT_2", new FieldDescriptor[]{new FieldDescriptor("FIELD1_ERR", "STRING"), new FieldDescriptor("FIELD3_ERR", "INTEGER")});
        this.m_o1 = this.m_context.createObject(CLASS_01, "--NORMAL-OBJECT--");
        this.m_o2 = this.m_context.createObject(CLASS_01, "OBJECT_FOR_NULL_OPERATIONS");
        this.m_nop = this.m_context.createMethod("METHOD1");
        this.m_o2.callMethod(this.m_nop);
        this.m_nop2 = this.m_context.createMethod("METHOD2");
        this.m_nop2.addImportingParameter("PARAMETER1", "STRING", RpeParameterMeta.Atomic, (IEdoValue)this.m_context.createValue("A simple parameter"));
        this.m_o2.callMethod(this.m_nop2);
        this.m_context.flush();
        if (!this.noErrors()) {
            this.dumpErrors();
            this.flop("Create object or a <nop> failed.", 3);
        }
    }

    public void cleanUp() {
        this.clear();
        try {
            this.m_o1.release();
            if (!this.noErrors()) {
                this.dumpErrors();
                this.flop("Release object failed.");
            }
        }
        catch (RpeIllegalMethodException ex) {
            this.logStackTrace(ex);
        }
        this.m_o1 = null;
        this.m_context.flush();
        try {
            this.m_context.release();
        }
        catch (RpeException ex) {
            this.logStackTrace(ex);
        }
        this.dumpErrors();
        this.m_context = null;
    }

    protected boolean noErrors() {
        RpeErrors errs = this.m_context.getErrors();
        return errs == null || errs.isEmpty();
    }

    protected void clear() {
        this.m_context.flush();
        RpeErrors errs = this.m_context.getErrors();
        if (errs != null) {
            int i = 0;
            int len = errs.size();
            while (i < len) {
                RpeError err = errs.getError(i);
                if (err.state == "FATAL") {
                    this.dumpErrors();
                    errs.clear();
                    this.flop("A fatal error has occured.", 3);
                }
                ++i;
            }
            errs.clear();
        }
    }

    protected void addNOP() {
        this.m_o2.callMethod(this.m_nop);
    }

    protected void addNOP2() {
        this.m_o2.callMethod(this.m_nop2);
    }

    protected void verifyError(int index, String category, String code, String object, String className, String method, String param, String value) {
        boolean good = true;
        StringBuffer msg = new StringBuffer("Error message :\n");
        RpeErrors errors = this.m_context.getErrors();
        this.verify(errors != null && index < errors.size(), "No error at index " + index);
        RpeError error = errors.getError(index);
        msg.append(error).append('\n');
        if (!this.compareIgnoreCase(category, error.category)) {
            msg.append("\tCategory is different\n");
            good = false;
        }
        if (!this.compareIgnoreCase(code, error.code)) {
            msg.append("\tError code is different\n");
            good = false;
        }
        if (!this.compareIgnoreCase(object, error.object)) {
            msg.append("\tObject is different\n");
            good = false;
        }
        if (!this.compareIgnoreCase(method, error.method)) {
            msg.append("\tMethod is different\n");
            good = false;
        }
        if (!this.compareIgnoreCase(param, error.parameter)) {
            msg.append("\tParameter is different\n");
            good = false;
        }
        this.verify(good, msg.toString(), 1);
    }

    protected boolean compareIgnoreCase(String str1, String str2) {
        str1 = str1 == null ? null : str1.trim();
        String string = str2 = str2 == null ? null : str2.trim();
        boolean isEqual = str1 == DONT_CARE || str2 == DONT_CARE ? true : (str1 == null || str1.length() == 0 ? str2 == null || str2.length() == 0 : str1.equalsIgnoreCase(str2));
        return isEqual;
    }

    protected void dumpErrors() {
        RpeErrors errors = this.m_context.getErrors();
        if (errors != null) {
            Iterator iter = ((AbstractList)errors).iterator();
            while (iter.hasNext()) {
                this.logln(iter.next().toString());
                this.log("\n");
            }
        }
    }
}

