/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.jco;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.JCO;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.edo.core.XMLHelper;
import com.sap.tc.col.rpe.RpeCommunicationException;
import com.sap.tc.col.rpe.RpeException;
import com.sap.tc.col.rpe.RpeIllegalMethodException;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.RpeParameterMeta;
import com.sap.tc.col.rpe.jco.RpeJCoConnectionBase;
import com.sap.tc.col.rpe.jco.RpeReturnsReadStream;
import com.sap.tc.col.rpe.jco.RpeValuesWriteStream;
import com.sap.tc.col.rpe.spi.IRpeConnectionFactory;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.logging.Location;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class RpeJCoConnection
extends RpeJCoConnectionBase {
    private static final String _className = (class$com$sap$tc$col$rpe$jco$RpeJCoConnection == null ? (class$com$sap$tc$col$rpe$jco$RpeJCoConnection = RpeJCoConnection.class$("com.sap.tc.col.rpe.jco.RpeJCoConnection")) : class$com$sap$tc$col$rpe$jco$RpeJCoConnection).getName();
    private static final Location _location = Location.getLocation((String)_className);
    private static IFunctionTemplate engineFunctionTemplate;
    private static int IMPORT_LINES;
    private static int IMPORT_PARAMS;
    private static int IMPORT_VALUES;
    private static int EXPORT_RETURNS;
    private static int EXPORT_ERRORS;
    private static int LINES_OBJECT;
    private static int LINES_OPCODE;
    private static int LINES_METHOD;
    private static int LINES_BEG_IMP;
    private static int LINES_CNT_IMP;
    private static int LINES_BEG_OUT;
    private static int LINES_CNT_OUT;
    private static int PARAMS_NAME;
    private static int PARAMS_TYPE;
    private static int PARAMS_VALUE;
    private static int PARAMS_META;
    private static int PARAMS_KIND;
    private static int VALUES_VALUE;
    private static int RETURNS_VINDX;
    private static int RETURNS_VALUE;
    private static int ERRORS_LINE;
    private static int ERRORS_PARAM;
    private static int ERRORS_VALUE;
    private static int ERRORS_CLASS;
    private static int ERRORS_CATEGORY;
    private static int ERRORS_CODE;
    private static int ERRORS_DESC;
    private static int ERRORS_STATE;
    private static int ERRORS_LOCATION;
    private static int IMPORT_LAST_TRIPTIME;
    protected JCO.Table m_tlines;
    protected JCO.Table m_tparams;
    protected int m_linesCount;
    protected int m_paramsCount;
    protected JCO.Table m_tvalues;
    protected int m_valuesCount;
    protected JCO.Table m_treturns;
    protected JCO.Table m_terrors;
    private String trace_loc;
    protected final XMLHelper m_xmlhelper = new XMLHelper();
    static /* synthetic */ Class class$com$sap$tc$col$rpe$jco$RpeJCoConnection;

    protected JCO.Function createFunction(JCO.Client connection) {
        JCO.Function function = RpeJCoConnection.getEngineFunctionTemplate().getFunction();
        JCO.ParameterList importparams = function.getImportParameterList();
        this.m_tlines = importparams.getTable(IMPORT_LINES);
        this.m_tparams = importparams.getTable(IMPORT_PARAMS);
        this.m_tvalues = importparams.getTable(IMPORT_VALUES);
        JCO.ParameterList exportparams = function.getExportParameterList();
        this.m_treturns = exportparams.getTable(EXPORT_RETURNS);
        this.m_terrors = exportparams.getTable(EXPORT_ERRORS);
        this.trace_loc = this.getProperty("esp.trace.location");
        return function;
    }

    protected void releaseFunction() {
        super.releaseFunction();
        this.m_tlines = null;
        this.m_tparams = null;
        this.m_tvalues = null;
    }

    protected void resetCall() {
        super.resetCall();
        try {
            this.m_linesCount = 0;
            this.m_tlines.clear();
            this.m_paramsCount = 0;
            this.m_tparams.clear();
            this.m_valuesCount = 0;
            this.m_tvalues.clear();
            this.m_treturns.clear();
            this.m_terrors.clear();
        }
        catch (JCO.Exception ex) {
            _location.catching("resetCall", (Throwable)ex);
            String message = "Unrecognized exception in JCO Connection in resetCall() : " + ex.getKey();
            _location.fatalT(message);
            RpeCommunicationException rex = new RpeCommunicationException(message, (Exception)((Object)ex));
            _location.throwing("resetCall", (Throwable)rex);
            throw rex;
        }
    }

    public int addParam(String name, String type, RpeParameterKind kind, RpeParameterMeta meta, IEdoValue value) {
        if (!this.isInCall()) {
            RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "not In Call", "addParam", "Should be in a call.");
            _location.throwing("addParam", (Throwable)re);
            throw re;
        }
        int iValue = this.m_valueManager.add(value, kind);
        try {
            this.m_tparams.appendRow();
            ++this.m_paramsCount;
            this.m_tparams.setValue(name, PARAMS_NAME);
            this.m_tparams.setValue(type, PARAMS_TYPE);
            this.m_tparams.setValue(iValue, PARAMS_VALUE);
            this.m_tparams.setValue(meta.toString(), PARAMS_META);
            this.m_tparams.setValue(kind.toString(), PARAMS_KIND);
        }
        catch (JCO.Exception ex) {
            String message;
            _location.catching("addParam", (Throwable)ex);
            switch (ex.getGroup()) {
                case 122: 
                case 123: 
                case 127: 
                case 131: 
                case 132: {
                    message = "Internal error in RPE JCO Connection in addParam(): " + ex.getKey();
                    _location.fatalT(message + " due to " + ex.getMessage());
                    break;
                }
                default: {
                    message = "Unrecognized exception in JCO Connection in addParam():" + ex.getKey();
                    _location.fatalT(message + " due to " + ex.getMessage());
                }
            }
            RpeCommunicationException cex = new RpeCommunicationException(message, (Exception)((Object)ex));
            _location.throwing("addParam", (Throwable)cex);
            throw cex;
        }
        return this.m_paramsCount;
    }

    public int addLine(String objectKey, String opCode, String method, int beginImportParams, int countImportParams, int beginExportingParams, int countExportingParams) {
        if (!this.isInCall()) {
            RpeIllegalMethodException re = new RpeIllegalMethodException(_className, "not In Call", "addLine", "Should be in a call.");
            _location.throwing("addLine", (Throwable)re);
            throw re;
        }
        try {
            this.m_tlines.appendRow();
            ++this.m_linesCount;
            this.m_tlines.setValue(objectKey, LINES_OBJECT);
            this.m_tlines.setValue(opCode, LINES_OPCODE);
            this.m_tlines.setValue(method, LINES_METHOD);
            this.m_tlines.setValue(beginImportParams, LINES_BEG_IMP);
            this.m_tlines.setValue(countImportParams, LINES_CNT_IMP);
            this.m_tlines.setValue(beginExportingParams, LINES_BEG_OUT);
            this.m_tlines.setValue(countExportingParams, LINES_CNT_OUT);
        }
        catch (JCO.Exception ex) {
            String message;
            _location.catching("addLine", (Throwable)ex);
            switch (ex.getGroup()) {
                case 122: 
                case 123: 
                case 127: 
                case 131: 
                case 132: {
                    message = "Internal error in RPE JCO Connection in addLine(): " + ex.getKey();
                    _location.fatalT(message + " due to " + ex.getMessage());
                    break;
                }
                default: {
                    message = "Unrecognized exception in JCO Connection in addLine(): " + ex.getKey();
                    _location.fatalT(message);
                    _location.fatalT(ex.getMessage());
                }
            }
            RpeCommunicationException cex = new RpeCommunicationException(message, (Exception)((Object)ex));
            _location.throwing("addLine", (Throwable)cex);
            throw cex;
        }
        return this.m_linesCount;
    }

    protected void fillInput() throws Exception {
        this.m_function.getImportParameterList().setValue(this.m_timeForLastCall, IMPORT_LAST_TRIPTIME);
        RpeValuesWriteStream os = new RpeValuesWriteStream(this.m_tvalues, this.m_xmlhelper);
        this.m_valueManager.writeValues(os);
        if (this.trace_loc != null) {
            try {
                String trace_file = this.trace_loc + System.currentTimeMillis() + "_request" + ".xml";
                this.dumpInputContents(trace_file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void processOutput() throws Exception {
        if (this.trace_loc != null) {
            try {
                String trace_file = this.trace_loc + System.currentTimeMillis() + "_response" + ".xml";
                this.dumpOutputContents(trace_file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.processReturns(this.m_treturns);
        this.processErrors(this.m_terrors);
    }

    private void processReturns(JCO.Table tresults) {
        RpeReturnsReadStream is = new RpeReturnsReadStream(tresults, this.m_xmlhelper);
        if (!tresults.isEmpty()) {
            tresults.firstRow();
            do {
                int valueIndex = tresults.getInt(RETURNS_VINDX);
                try {
                    this.m_valueManager.updateValue(valueIndex, is);
                }
                catch (RpeException ex) {
                    _location.catching("processResults at index " + valueIndex, (Throwable)ex);
                    this.raiseErrorForValue(valueIndex, ex.getMessage());
                }
            } while (tresults.nextRow());
        }
    }

    private void processErrors(JCO.Table terrors) {
        if (!terrors.isEmpty()) {
            terrors.firstRow();
            do {
                String param;
                String object;
                String opCode;
                String method;
                int iLine = this.to_int(terrors.getString(ERRORS_LINE));
                int iParam = this.to_int(terrors.getString(ERRORS_PARAM));
                int iValue = this.to_int(terrors.getString(ERRORS_VALUE));
                String category = terrors.getString(ERRORS_CATEGORY);
                String errClass = terrors.getString(ERRORS_CLASS);
                String errCode = terrors.getString(ERRORS_CODE);
                String errState = terrors.getString(ERRORS_STATE);
                byte[] errDesc = terrors.getByteArray(ERRORS_DESC);
                String errLocation = terrors.getString(ERRORS_LOCATION);
                if (iLine > 0 && iLine <= this.m_linesCount) {
                    this.m_tlines.setRow(iLine - 1);
                    method = this.m_tlines.getString(LINES_METHOD);
                    opCode = this.m_tlines.getString(LINES_OPCODE);
                    object = this.m_tlines.getString(LINES_OBJECT);
                } else {
                    method = null;
                    opCode = null;
                    object = null;
                }
                if (iParam > 0 && iParam <= this.m_paramsCount) {
                    this.m_tparams.setRow(iParam - 1);
                    param = this.m_tparams.getString(PARAMS_NAME);
                } else {
                    param = iParam == Integer.MIN_VALUE ? terrors.getString(ERRORS_PARAM) : null;
                }
                String value = iValue > 0 && iValue <= this.m_valuesCount ? this.m_valueManager.getValue(iValue).toString() : (iValue == Integer.MIN_VALUE ? terrors.getString(ERRORS_VALUE) : null);
                this.m_errorManager.addError(method, opCode, object, errClass, param, value, category, errCode, RpeJCoConnection.toString(errDesc), errState, errLocation, this);
            } while (terrors.nextRow());
        }
    }

    private void raiseErrorForValue(int valueIndex, String message) {
        String methodName = null;
        String opCode = null;
        String objectName = null;
        String paramName = null;
        int paramIndex = this.getOutParamIndexForValue(valueIndex);
        int linesIndex = 0;
        if (paramIndex > 0) {
            this.m_tparams.setRow(paramIndex - 1);
            paramName = this.m_tparams.getString(PARAMS_NAME);
            linesIndex = this.getLineForParam(paramIndex);
        }
        if (linesIndex > 0) {
            this.m_tlines.setRow(linesIndex - 1);
            methodName = this.m_tlines.getString(LINES_METHOD);
            opCode = this.m_tlines.getString(LINES_OPCODE);
            objectName = this.m_tlines.getString(LINES_OBJECT);
        }
        this.m_errorManager.addError(methodName, opCode, objectName, null, paramName, null, "RPE", "RPE_CRF", message, "RECOVERED", null, this);
    }

    private int getOutParamIndexForValue(int valueIndex) {
        int paramIndex = 0;
        this.m_tparams.firstRow();
        do {
            RpeParameterKind kind;
            if (valueIndex != this.m_tparams.getInt(PARAMS_VALUE) || (kind = RpeParameterKind.fromString(this.m_tparams.getString(PARAMS_KIND))) == null || kind == RpeParameterKind.Importing) continue;
            paramIndex = this.m_tparams.getRow() + 1;
        } while (this.m_tparams.nextRow());
        return paramIndex;
    }

    private int getLineForParam(int paramIndex) {
        int lineIndex = 0;
        this.m_tlines.firstRow();
        do {
            int beg_params = this.m_tlines.getInt(LINES_BEG_IMP);
            int cnt_params = this.m_tlines.getInt(LINES_CNT_IMP);
            if (paramIndex >= beg_params && paramIndex < beg_params + cnt_params) {
                lineIndex = this.m_tlines.getRow() + 1;
                break;
            }
            beg_params = this.m_tlines.getInt(LINES_BEG_OUT);
            cnt_params = this.m_tlines.getInt(LINES_CNT_OUT);
            if (paramIndex < beg_params || paramIndex >= beg_params + cnt_params) continue;
            lineIndex = this.m_tlines.getRow() + 1;
            break;
        } while (this.m_tlines.nextRow());
        return lineIndex;
    }

    private int to_int(String value) {
        int ivalue;
        if (null == value) {
            ivalue = 0;
        } else if ((value = value.trim()).length() == 0) {
            ivalue = 0;
        } else {
            try {
                ivalue = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                _location.catching("to_int of '" + value + "'", (Throwable)ex);
                ivalue = Integer.MIN_VALUE;
            }
        }
        return ivalue;
    }

    private static String toString(byte[] data) {
        try {
            return data == null ? "" : new String(data, "UTF-8");
        }
        catch (Exception ex) {
            _location.catching("toString", (Throwable)ex);
            return "";
        }
    }

    private static IFunctionTemplate getEngineFunctionTemplate() {
        if (engineFunctionTemplate == null) {
            Class clazz = class$com$sap$tc$col$rpe$jco$RpeJCoConnection == null ? (class$com$sap$tc$col$rpe$jco$RpeJCoConnection = RpeJCoConnection.class$("com.sap.tc.col.rpe.jco.RpeJCoConnection")) : class$com$sap$tc$col$rpe$jco$RpeJCoConnection;
            synchronized (clazz) {
                if (engineFunctionTemplate == null) {
                    _location.pathT("Creating Engine function template.");
                    JCO.MetaData input_lines = new JCO.MetaData("LINES", 7);
                    input_lines.addInfo("OBJECT", 29, 0, 0, 0);
                    input_lines.addInfo("OPCODE", 29, 0, 0, 0);
                    input_lines.addInfo("METHOD", 29, 0, 0, 0);
                    input_lines.addInfo("BEG_IMP_PARMS", 29, 0, 0, 0);
                    input_lines.addInfo("CNT_IMP_PARMS", 29, 0, 0, 0);
                    input_lines.addInfo("BEG_OUT_PARMS", 29, 0, 0, 0);
                    input_lines.addInfo("CNT_OUT_PARMS", 29, 0, 0, 0);
                    LINES_OBJECT = input_lines.indexOf("OBJECT");
                    LINES_OPCODE = input_lines.indexOf("OPCODE");
                    LINES_METHOD = input_lines.indexOf("METHOD");
                    LINES_BEG_IMP = input_lines.indexOf("BEG_IMP_PARMS");
                    LINES_CNT_IMP = input_lines.indexOf("CNT_IMP_PARMS");
                    LINES_BEG_OUT = input_lines.indexOf("BEG_OUT_PARMS");
                    LINES_CNT_OUT = input_lines.indexOf("CNT_OUT_PARMS");
                    JCO.MetaData input_params = new JCO.MetaData("PARAMS", 5);
                    input_params.addInfo("NAME", 29, 0, 0, 0);
                    input_params.addInfo("TYPE", 29, 0, 0, 0);
                    input_params.addInfo("VALUE", 29, 0, 0, 0);
                    input_params.addInfo("META", 29, 0, 0, 0);
                    input_params.addInfo("KIND", 29, 0, 0, 0);
                    PARAMS_NAME = input_params.indexOf("NAME");
                    PARAMS_TYPE = input_params.indexOf("TYPE");
                    PARAMS_VALUE = input_params.indexOf("VALUE");
                    PARAMS_META = input_params.indexOf("META");
                    PARAMS_KIND = input_params.indexOf("KIND");
                    JCO.MetaData input_values = new JCO.MetaData("VALUES", 1);
                    input_values.addInfo("VALUE", 30, 0, 0, 0);
                    VALUES_VALUE = input_values.indexOf("VALUE");
                    JCO.MetaData input = new JCO.MetaData("INPUT", 3);
                    input.addInfo("LINES", 99, 0, 0, 0, 1, (Object)input_lines);
                    input.addInfo("PARAMS", 99, 0, 0, 0, 1, (Object)input_params);
                    input.addInfo("VALUES", 99, 0, 0, 0, 1, (Object)input_values);
                    input.addInfo("LAST_TRIPTIME", 8, 2);
                    IMPORT_LINES = input.indexOf("LINES");
                    IMPORT_PARAMS = input.indexOf("PARAMS");
                    IMPORT_VALUES = input.indexOf("VALUES");
                    IMPORT_LAST_TRIPTIME = input.indexOf("LAST_TRIPTIME");
                    JCO.MetaData output_errors = new JCO.MetaData("ERRORS", 8);
                    output_errors.addInfo("CATEGORY", 29, 0, 0, 0);
                    output_errors.addInfo("LINE", 29, 0, 0, 0);
                    output_errors.addInfo("CLASS", 29, 0, 0, 0);
                    output_errors.addInfo("PARAM", 29, 0, 0, 0);
                    output_errors.addInfo("VALUE", 29, 0, 0, 0);
                    output_errors.addInfo("CODE", 29, 0, 0, 0);
                    output_errors.addInfo("STATE", 29, 0, 0, 0);
                    output_errors.addInfo("DESCRIPTION", 30, 0, 0, 0);
                    output_errors.addInfo("LOCATION", 29, 0, 0, 0);
                    ERRORS_CATEGORY = output_errors.indexOf("CATEGORY");
                    ERRORS_LINE = output_errors.indexOf("LINE");
                    ERRORS_CLASS = output_errors.indexOf("CLASS");
                    ERRORS_PARAM = output_errors.indexOf("PARAM");
                    ERRORS_VALUE = output_errors.indexOf("VALUE");
                    ERRORS_CODE = output_errors.indexOf("CODE");
                    ERRORS_STATE = output_errors.indexOf("STATE");
                    ERRORS_DESC = output_errors.indexOf("DESCRIPTION");
                    ERRORS_LOCATION = output_errors.indexOf("LOCATION");
                    JCO.MetaData output_returns = new JCO.MetaData("RETURNS", 2);
                    output_returns.addInfo("VINDX", 29, 0, 0, 0);
                    output_returns.addInfo("VALUE", 30, 0, 0, 0);
                    RETURNS_VINDX = output_returns.indexOf("VINDX");
                    RETURNS_VALUE = output_returns.indexOf("VALUE");
                    JCO.MetaData output = new JCO.MetaData("OUTPUT", 2);
                    output.addInfo("ERRORS", 99, 0, 0, 0, 2, (Object)output_errors);
                    output.addInfo("RETURNS", 99, 0, 0, 0, 2, (Object)output_returns);
                    EXPORT_ERRORS = output.indexOf("ERRORS");
                    EXPORT_RETURNS = output.indexOf("RETURNS");
                    IMetaData tables = null;
                    JCO.AbapException[] exceptions = new JCO.AbapException[]{new JCO.AbapException("NO_AUTHORITY", "NO_AUTHORITY"), new JCO.AbapException("OBJECT_NOT_FOUND", "OBJECT_NOT_FOUND"), new JCO.AbapException("RSE_ERRORS", "RSE_ERRORS"), new JCO.AbapException("SYNTAX_ERROR", "SYNTAX_ERROR"), new JCO.AbapException("UNKNOWN_OPCODE", "UNKNOWN_OPCODE")};
                    engineFunctionTemplate = new JCO.FunctionTemplate("RPE_EXECUTE", (IMetaData)input, (IMetaData)output, tables, exceptions);
                    _location.pathT("Created Engine function template.");
                    if (_location.getEffectiveSeverity() <= 100) {
                        _location.debugT(engineFunctionTemplate.toString());
                    }
                }
            }
        }
        return engineFunctionTemplate;
    }

    public void dumpOutputContents(String file) throws Exception {
        int currentRow_r = this.m_treturns.getRow();
        int currentRow_e = this.m_terrors.getRow();
        try {
            FileOutputStream os = new FileOutputStream(file, false);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, "UTF-8");
            w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<esf:response xmlns:esf=\"http://www.sap.com/esf\"><esf:returns>");
            if (!this.m_treturns.isEmpty()) {
                this.m_treturns.firstRow();
                do {
                    w.write("<esf:return index=\"");
                    w.write(this.m_treturns.getString(RETURNS_VINDX));
                    w.write("\">");
                    ((Writer)w).flush();
                    byte[] data = this.m_treturns.getByteArray(RETURNS_VALUE);
                    if (data != null) {
                        os.write(data);
                    }
                    w.write("</esf:return>");
                } while (this.m_treturns.nextRow());
            }
            w.write("</esf:returns><esf:errors>");
            if (this.m_terrors.isEmpty()) {
                w.write("<" + this.m_terrors.getName() + "/>");
            } else {
                w.write("There are errors; error table is not dumped now.");
            }
            w.write("</esf:errors></esf:response>");
            ((Writer)w).flush();
            os.close();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.m_treturns.setRow(currentRow_r);
            this.m_terrors.setRow(currentRow_e);
            throw throwable;
        }
        this.m_treturns.setRow(currentRow_r);
        this.m_terrors.setRow(currentRow_e);
    }

    public void dumpInputContents(String file) throws Exception {
        int currentRow_v = this.m_tvalues.getRow();
        try {
            FileOutputStream os = new FileOutputStream(file, false);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, "UTF-8");
            w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<esf:request xmlns:esf=\"http://www.sap.com/esf\"><esf:lines>");
            w.write(this.m_tlines.toXML());
            w.write("</esf:lines><esf:params>");
            w.write(this.m_tparams.toXML());
            w.write("</esf:params><esf:values>");
            if (!this.m_tvalues.isEmpty()) {
                this.m_tvalues.firstRow();
                do {
                    byte[] data;
                    if ((data = this.m_tvalues.getByteArray(VALUES_VALUE)) != null) {
                        w.write("<esf:value>");
                        ((Writer)w).flush();
                        os.write(data);
                        w.write("</esf:value>");
                        continue;
                    }
                    w.write("<esf:value/>");
                } while (this.m_tvalues.nextRow());
            }
            w.write("</esf:values></esf:request>");
            ((Writer)w).flush();
            os.close();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.m_tvalues.setRow(currentRow_v);
            throw throwable;
        }
        this.m_tvalues.setRow(currentRow_v);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.jco").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/jco/RpeJCoConnection.java#1 $");
    }

    public static class ConnectionFactory
    implements IRpeConnectionFactory {
        public IRpeConnectionSpi createConnection(String channel) {
            return new RpeJCoConnection();
        }
    }
}

