/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.core;

import com.sap.tc.col.edo.EdoException;
import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.edo.IEdoWriteStream;
import com.sap.tc.col.edo.core.EdoAbstractValue;
import com.sap.tc.col.rpe.RpeException;
import com.sap.tc.col.rpe.RpeIllegalArgumentException;
import com.sap.tc.col.rpe.RpeObject;
import com.sap.tc.col.rpe.RpeParameterKind;
import com.sap.tc.col.rpe.core.RpeParameterKindBase;
import com.sap.tc.col.rpe.env.CCDirectives;
import com.sap.tc.col.rpe.spi.IRpeValueManager;
import com.sap.tc.logging.Location;
import java.util.ArrayList;

public class RpeValueManager
implements IRpeValueManager,
CCDirectives {
    private static final String _className = (class$com$sap$tc$col$rpe$core$RpeValueManager == null ? (class$com$sap$tc$col$rpe$core$RpeValueManager = RpeValueManager.class$("com.sap.tc.col.rpe.core.RpeValueManager")) : class$com$sap$tc$col$rpe$core$RpeValueManager).getName();
    private static final Location _location = Location.getLocation((String)_className);
    private ArrayList m_inValues = new ArrayList();
    private ArrayList m_outValues = new ArrayList();
    static /* synthetic */ Class class$com$sap$tc$col$rpe$core$RpeValueManager;

    public int add(IEdoValue value, RpeParameterKind kind) {
        return this.add((EdoAbstractValue)value, (RpeParameterKindBase)kind);
    }

    public int add(EdoAbstractValue value, RpeParameterKindBase kind) {
        int size = this.m_inValues.size();
        int index = value.getIndex();
        if (index == -1) {
            if (kind.isInput() || value instanceof RpeObject) {
                this.m_inValues.add(value);
            } else {
                this.m_inValues.add(null);
            }
            if (kind.isOutput()) {
                this.m_outValues.add(value);
            } else {
                this.m_outValues.add(null);
            }
            index = ++size;
            value.setIndex(index);
        } else if (index <= size && (value == this.m_inValues.get(index - 1) || value == this.m_outValues.get(index - 1))) {
            if (kind.isInput()) {
                this.m_inValues.set(index - 1, value);
            }
            if (kind.isOutput()) {
                this.m_outValues.set(index - 1, value);
            }
        } else {
            String message = "Internal error: found inconsistant index for value:index = " + index + "size = " + size + ".";
            _location.fatalT(message);
            RpeException ex = new RpeException(message);
            throw ex;
        }
        return index;
    }

    public void updateValue(int index, IEdoReadStream stream) {
        EdoAbstractValue value;
        if (index >= 1 && index <= this.m_outValues.size()) {
            value = (EdoAbstractValue)this.m_outValues.get(index - 1);
            if (value == null) {
                RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "updateValue", "index", String.valueOf(index), "Value at index does not represent an output value.");
                _location.throwing("updateValue", (Throwable)ex);
                throw ex;
            }
        } else {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "updateValue", "index", String.valueOf(index), "Out of range; should be more than 0 and less than " + this.m_outValues.size());
            _location.throwing("updateValue", (Throwable)ex);
            throw ex;
        }
        try {
            value.readFrom(stream);
        }
        catch (EdoException ex) {
            _location.catching("updateValue", (Throwable)ex);
            RpeException nex = new RpeException("Error while de-serializing", ex);
            _location.throwing("updateValue", (Throwable)nex);
            throw nex;
        }
    }

    public void writeValues(IEdoWriteStream stream) {
        int size = this.m_inValues.size();
        int index = 0;
        while (index < size) {
            EdoAbstractValue value = (EdoAbstractValue)this.m_inValues.get(index);
            try {
                if (value != null) {
                    value.writeTo(stream);
                } else {
                    value = (EdoAbstractValue)this.m_outValues.get(index);
                    value.clear();
                    value.writeTo(stream);
                }
            }
            catch (EdoException ex) {
                _location.catching("writeValues", (Throwable)ex);
                RpeException nex = new RpeException("Error while serializing", ex);
                _location.throwing("writeValues", (Throwable)nex);
                throw nex;
            }
            ++index;
        }
    }

    public void clear() {
        int index = 0;
        int size = this.m_inValues.size();
        while (index < size) {
            EdoAbstractValue value = (EdoAbstractValue)this.m_inValues.get(index);
            if (value == null) {
                value = (EdoAbstractValue)this.m_outValues.get(index);
            }
            if (value != null) {
                value.setIndex(-1);
            }
            ++index;
        }
        this.m_inValues.clear();
        this.m_outValues.clear();
    }

    public IEdoValue getValue(int index) {
        if (index > this.m_inValues.size() || index < 1) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "updateValue", "index", String.valueOf(index), "Out of range; should be more than 0 and less than " + this.m_outValues.size());
            _location.throwing("updateValue", (Throwable)ex);
            throw ex;
        }
        Object value = this.m_inValues.get(index - 1);
        if (value == null) {
            value = this.m_outValues.get(index - 1);
        }
        return (IEdoValue)value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/core/RpeValueManager.java#1 $");
    }
}

