/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.rpe.core;

import com.sap.tc.col.rpe.RpeException;
import com.sap.tc.col.rpe.RpeIllegalArgumentException;
import com.sap.tc.col.rpe.spi.IRpeConnectionFactory;
import com.sap.tc.col.rpe.spi.IRpeConnectionSpi;
import com.sap.tc.logging.Location;

public class ClassNameConnectionFactory
implements IRpeConnectionFactory {
    private static final String _className = (class$com$sap$tc$col$rpe$core$ClassNameConnectionFactory == null ? (class$com$sap$tc$col$rpe$core$ClassNameConnectionFactory = ClassNameConnectionFactory.class$("com.sap.tc.col.rpe.core.ClassNameConnectionFactory")) : class$com$sap$tc$col$rpe$core$ClassNameConnectionFactory).getName();
    static final Location _location = Location.getLocation((String)_className);
    private Class m_channelClass;
    public final String m_channelClassName;
    static /* synthetic */ Class class$com$sap$tc$col$rpe$core$ClassNameConnectionFactory;

    public ClassNameConnectionFactory(String className) {
        this.m_channelClassName = className;
        try {
            this.m_channelClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            _location.warningT("Channel class " + className + " could not be loaded.");
        }
    }

    public IRpeConnectionSpi createConnection(String channel) {
        Class<?> channelClass;
        if (this.m_channelClass == null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                channelClass = classLoader.loadClass(this.m_channelClassName);
            }
            catch (ClassNotFoundException ignore) {
                channelClass = null;
            }
        } else {
            channelClass = this.m_channelClass;
        }
        if (channelClass == null) {
            RpeIllegalArgumentException ex = new RpeIllegalArgumentException(_className, "createConnection", "channel", channel, "Channel implementation class \"" + this.m_channelClassName + "\" not found : ");
            _location.throwing("createConnection", (Throwable)ex);
            throw ex;
        }
        try {
            return (IRpeConnectionSpi)channelClass.newInstance();
        }
        catch (Exception e) {
            _location.catching("createConnection", (Throwable)e);
            RpeException ex = new RpeException("Could not create channel " + channel, e);
            _location.throwing("createConnection", (Throwable)ex);
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.rpe.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_rpe/java/_core/com/sap/tc/col/rpe/core/ClassNameConnectionFactory.java#1 $");
    }
}

