/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ni;

import com.sap.ni.NI;
import com.sap.ni.NiException;
import com.sap.ni.NiMsg;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class NiRouteErr {
    public static byte[] eyecatcher = NI.NI_RTERR;
    private byte version;
    private byte opcode;
    private byte alignment;
    private int nirc;
    private String message;
    private Vector errMsgs;

    public NiRouteErr(NiMsg nimsg) throws NiException {
        byte[] stream = nimsg.msg;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(stream));
        try {
            int i = 0;
            while (i < eyecatcher.length) {
                if (dis.readByte() != eyecatcher[i]) {
                    throw new NiException(" invalid err message ");
                }
                ++i;
            }
            this.version = dis.readByte();
            this.opcode = dis.readByte();
            this.alignment = dis.readByte();
            this.nirc = dis.readInt();
            int space_used = dis.readInt();
            this.errMsgs = this.getErr(stream, space_used);
            this.message = "\n";
            int i2 = 0;
            while (i2 < this.errMsgs.size()) {
                this.message = this.message + this.getErrField(i2);
                ++i2;
            }
        }
        catch (IOException e) {
            System.out.println("IOException caught: " + e);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isError() {
        return this.opcode == NI.NIOP_NOOP;
    }

    public void dump() {
        System.out.println("version = " + this.version);
        System.out.println("opcode = " + this.opcode);
        System.out.println("nirc = " + this.nirc);
        System.out.println(this.message);
    }

    private String getNextString(byte[] s, int len) {
        int off = 20;
        return new String(s, off, len);
    }

    private String getErrField(int i) {
        String pref = null;
        boolean ret = false;
        switch (i) {
            case 2: {
                pref = "Description: ";
                break;
            }
            case 3: {
                pref = "Returncode: ";
                break;
            }
            case 4: {
                pref = "Component: ";
                break;
            }
            case 5: {
                pref = "Release: ";
                break;
            }
            case 6: {
                pref = "Version";
                break;
            }
            case 7: {
                pref = "Module: ";
                break;
            }
            case 8: {
                pref = "Line: ";
                break;
            }
            case 9: {
                pref = "Detail: ";
                break;
            }
            case 10: {
                pref = "Time: ";
                break;
            }
            case 11: {
                pref = "Syscall: ";
                break;
            }
            case 12: {
                pref = "Errno: ";
                break;
            }
            case 13: {
                pref = "ErrTxt: ";
                break;
            }
            case 14: {
                pref = "ErrCount: ";
                break;
            }
            case 15: {
                pref = "Location: ";
                break;
            }
            case 16: {
                pref = "Detail: ";
                break;
            }
            default: {
                pref = "";
                ret = true;
            }
        }
        if (ret) {
            return "";
        }
        return new String(pref + this.errMsgs.elementAt(i) + "\n");
    }

    private Vector getErr(byte[] s, int len) {
        int off = 20;
        int l = len;
        Vector<String> m = new Vector<String>();
        while (off < len) {
            int i = off;
            while (s[i] != 0 && i < len) {
                ++i;
            }
            String str = new String(s, off, i - off);
            m.addElement(str);
            off = i + 1;
        }
        return m;
    }
}

