/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ni;

import com.sap.ni.NI;
import com.sap.ni.NiException;
import com.sap.ni.NiRouteEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class NiRoute {
    public static byte[] eyecatcher = new byte[]{78, 73, 95, 82, 79, 85, 84, 69, 0};
    public static int VERSION = 2;
    private int iroute_version;
    private int ni_version;
    private int total_entries;
    private byte talkmode;
    private byte options;
    private byte unused;
    private int rest_entries;
    private int space_used;
    private int next_entry;
    private int next_offset;
    private int total_length;
    Vector route_entries;

    public NiRoute(String s, byte talkmode_param) throws NiException {
        String hostname = null;
        String service = null;
        String password = null;
        boolean invalid = false;
        this.route_entries = new Vector();
        this.iroute_version = VERSION;
        this.ni_version = NI.VERSION;
        String canon = new String(s);
        StringTokenizer st = new StringTokenizer(canon, "/");
        int count = st.countTokens();
        if (count == 1) {
            hostname = new String(s);
            System.out.println("hostname = " + hostname);
        }
        int i = 0;
        while (i < count && !invalid) {
            String elem = st.nextToken();
            if (elem.length() != 1) {
                throw new NiException("route " + s + ": /" + elem + "/ not allowed");
            }
            char c = elem.charAt(0);
            switch (c) {
                case 'H': 
                case 'h': {
                    if (i > 0) {
                        this.route_entries.addElement(new NiRouteEntry(hostname, service, password));
                    }
                    if (i < count - 1) {
                        hostname = new String(st.nextToken());
                        ++i;
                        password = null;
                        service = null;
                        break;
                    }
                    throw new NiException("route " + s + " last token /" + c + "/ not allowed");
                }
                case 'S': 
                case 's': {
                    if (i < count - 1) {
                        service = new String(st.nextToken());
                        ++i;
                        break;
                    }
                    throw new NiException("route " + s + " last token /" + c + "/ not allowed");
                }
                case 'P': 
                case 'p': {
                    if (i < count - 1) {
                        password = new String(st.nextToken());
                        ++i;
                        break;
                    }
                    throw new NiException("route " + s + " last token /" + c + "/ not allowed");
                }
                default: {
                    throw new NiException(s + ": token /" + c + "/ invalid");
                }
            }
            ++i;
        }
        this.route_entries.addElement(new NiRouteEntry(hostname, service, password));
        int i2 = 0;
        while (i2 < this.route_entries.size()) {
            this.total_length += ((NiRouteEntry)this.route_entries.elementAt(i2)).getLength();
            ++i2;
        }
        this.space_used = this.total_length;
        this.total_length += 24;
        this.talkmode = talkmode_param;
        this.total_entries = this.route_entries.size();
        this.next_entry = 0;
        this.next_offset = ((NiRouteEntry)this.route_entries.elementAt(0)).getLength();
        this.rest_entries = this.total_entries - this.next_entry - 1;
    }

    public NiRoute(String s) throws NiException {
        this(s, NI.NI_TALK_NATIVE2);
    }

    public NiRoute(byte[] stream) throws NiException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(stream));
        int offset = 0;
        int total_used = stream.length;
        int next = 0;
        this.route_entries = new Vector();
        try {
            int i = 0;
            while (i < eyecatcher.length) {
                if (dis.readByte() != eyecatcher[i]) {
                    throw new NiException(" invalid route ");
                }
                ++i;
            }
            this.iroute_version = dis.readByte();
            this.ni_version = dis.readByte();
            this.total_entries = dis.readByte();
            this.talkmode = dis.readByte();
            this.options = dis.readByte();
            this.unused = dis.readByte();
            this.rest_entries = dis.readByte();
            this.space_used = dis.readInt();
            next = dis.readInt();
            int i2 = 0;
            while (i2 < this.total_entries) {
                if (offset == next) {
                    this.next_entry = i2;
                }
                String host = this.getNextString(stream, offset);
                String serv = this.getNextString(stream, offset += host.length() + 1);
                String pass = this.getNextString(stream, offset += serv.length() + 1);
                System.out.println("host: " + host + " server " + serv);
                if ((offset += pass.length() + 1) > this.space_used) {
                    System.out.print("NiRoute( byte [] ): invalid Route. ");
                    System.out.println("offset: " + offset);
                    this.printIt();
                }
                this.route_entries.addElement(new NiRouteEntry(host, serv, pass));
                ++i2;
            }
        }
        catch (IOException e) {
            System.out.println("IOException caught: " + e);
        }
        this.next_offset = next + ((NiRouteEntry)this.route_entries.elementAt(0)).getLength();
        int i = 0;
        while (i < this.route_entries.size()) {
            this.total_length += ((NiRouteEntry)this.route_entries.elementAt(i)).getLength();
            ++i;
        }
        this.total_length += 24;
        if (this.total_entries != this.route_entries.size()) {
            System.out.print("NiRoute( byte [] ): invalid Route. ");
            System.out.println("total_entries: " + this.total_entries);
            System.out.println("route_entries.size() = " + this.route_entries.size());
            this.printIt();
        }
    }

    private String getNextString(byte[] s, int off) {
        int i = off + 24;
        int len = 0;
        i = off + 24;
        while (s[i] != 0 && i < 10000) {
            ++len;
            ++i;
        }
        return new String(s, off + 24, len);
    }

    public byte[] toStream() throws IOException {
        int len = this.total_length;
        byte[] buffer = new byte[this.total_length];
        int offset = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.total_length);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.write(eyecatcher, 0, eyecatcher.length);
        dos.writeByte(this.iroute_version);
        dos.writeByte(this.ni_version);
        dos.writeByte(this.total_entries);
        dos.writeByte(this.talkmode);
        dos.writeByte(this.options);
        dos.writeByte(this.unused);
        dos.writeByte(this.rest_entries);
        dos.writeInt(this.space_used);
        dos.writeInt(this.next_offset);
        byte[] b = bos.toByteArray();
        offset = 0;
        while (offset < b.length) {
            buffer[offset] = b[offset];
            ++offset;
        }
        int i = 0;
        while (i < this.route_entries.size()) {
            int j;
            NiRouteEntry re = (NiRouteEntry)this.route_entries.elementAt(i);
            String s = re.getHost();
            if (s != null) {
                b = s.getBytes();
                j = 0;
                while (j < b.length) {
                    buffer[offset++] = b[j];
                    ++j;
                }
            }
            buffer[offset++] = 0;
            s = re.getPort();
            if (s != null) {
                b = s.getBytes();
                j = 0;
                while (j < b.length) {
                    buffer[offset++] = b[j];
                    ++j;
                }
            }
            buffer[offset++] = 0;
            s = re.getPass();
            if (s != null) {
                b = s.getBytes();
                j = 0;
                while (j < b.length) {
                    buffer[offset++] = b[j];
                    ++j;
                }
            }
            buffer[offset++] = 0;
            ++i;
        }
        return buffer;
    }

    public void printIt() {
        int count = this.route_entries.size();
        int i = 0;
        while (i < count) {
            NiRouteEntry e = (NiRouteEntry)this.route_entries.elementAt(i);
            System.out.print("Entry " + i + " Hostname: " + e.getHost());
            System.out.print(" Service: " + e.getPort());
            System.out.println(" Password: " + e.getPass());
            ++i;
        }
        System.out.println("iroute_version: " + this.iroute_version);
        System.out.println("total_entries: " + this.total_entries);
        System.out.println("talkmode: " + this.talkmode);
        System.out.println("options: " + this.options);
        System.out.println("rest_entries: " + this.rest_entries);
        System.out.println("space_used: " + this.space_used);
        System.out.println("next_entry: " + this.next_entry);
    }

    public InetAddress getNextHost() throws UnknownHostException {
        NiRouteEntry re = (NiRouteEntry)this.route_entries.elementAt(this.next_entry);
        String h = re.getHost();
        if (h != null) {
            return InetAddress.getByName(h);
        }
        return null;
    }

    public int getNextPort() {
        NiRouteEntry re = (NiRouteEntry)this.route_entries.elementAt(this.next_entry);
        String s = re.getPort();
        if (s != null) {
            try {
                URL u = new URL("http://a:" + s);
                return u.getPort();
            }
            catch (MalformedURLException e) {
                System.out.println(e);
            }
        }
        return 2;
    }

    public int getRestEntries() {
        return this.rest_entries;
    }
}

