/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ni;

import com.sap.ni.NI;
import com.sap.ni.NiException;
import com.sap.ni.NiMsg;
import com.sap.ni.NiRoute;
import com.sap.ni.NiRouteErr;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class NiHandle {
    private Socket socket;
    private NiRoute route;
    private int talkmode;
    private int state;
    private boolean waitForPong;
    private int tracelevel;

    public NiHandle(Socket s, int tl, byte talkmode_param) {
        this.socket = s;
        this.talkmode = talkmode_param;
        this.waitForPong = false;
        this.tracelevel = tl;
    }

    public NiHandle(Socket s, int tl) {
        this(s, tl, NI.NI_TALK_NATIVE2);
    }

    public NiHandle(Socket s) {
        this(s, 2);
    }

    public NiHandle(String s, int tl, byte talkmode_param) throws UnknownHostException, IOException, NiException {
        this.tracelevel = tl;
        this.route = new NiRoute(s, talkmode_param);
        if (this.tracelevel >= 3) {
            this.route.printIt();
        }
        InetAddress ip = this.route.getNextHost();
        int port = this.route.getNextPort();
        try {
            this.socket = new Socket(ip, port);
            if (this.route.getRestEntries() > 0) {
                NiMsg m = new NiMsg();
                this.waitForPong = true;
                this.send(this.route.toStream());
                this.recv(m);
                this.trace("Route ok!");
            } else {
                this.trace(" no route ");
            }
        }
        catch (ConnectException e) {
            this.trace(1, " Connect Exception caught ");
            throw new NiException(e);
        }
        this.waitForPong = false;
    }

    public NiHandle(String s, int tl) throws UnknownHostException, IOException, NiException {
        this(s, tl, NI.NI_TALK_NATIVE2);
    }

    public NiHandle(String s) throws UnknownHostException, IOException, NiException {
        this(s, 2);
    }

    public Socket getSocket() {
        return this.socket;
    }

    /*
     * Unable to fully structure code
     */
    public void recv(NiMsg m) throws NiException {
        block6: {
            retLen = 0;
            is = null;
            len_b = new byte[4];
            while (true) {
                if (is != null) ** GOTO lbl8
                {
                    is = this.socket.getInputStream();
                    continue;
lbl8:
                    // 1 sources

                    is.read(len_b, 0, 4);
                    len = NI.hostInt(len_b);
                    m.msg = new byte[len];
                    m.len = len;
                    if (len <= 0) {
                        throw new NiException(" Connection closed ");
                    }
                    len = 0;
                    while ((retLen = is.read(m.msg, len, m.len - len)) >= 0 && (len += retLen) < m.len) {
                    }
                }
                if (m.isNiRouteErr()) {
                    err = new NiRouteErr(m);
                    throw new NiException(err.getMessage());
                }
                if (m.len != NI.NI_PING.length) break block6;
                if (m.isNiPing()) {
                    this.trace("NiHandle.recv: NI_PING received\n");
                    this.send(NI.NI_PONG);
                    continue;
                }
                if (m.isNiPong() && this.waitForPong) break;
            }
            this.waitForPong = false;
            return;
        }
    }

    public void send(byte[] buffer) throws NiException {
        int len = buffer.length;
        byte[] b = NI.netInt(len);
        try {
            OutputStream os = this.socket.getOutputStream();
            os.write(b);
            os.write(buffer);
        }
        catch (IOException e) {
            this.trace(" Exception during send (): " + e);
            throw new NiException(e);
        }
    }

    public void niPing() {
        NiMsg m = new NiMsg();
        try {
            this.send(NI.NI_PING);
            this.trace("NI_PING sent");
            this.waitForPong = true;
            this.recv(m);
        }
        catch (NiException niException) {
            // empty catch block
        }
        if (!this.waitForPong) {
            this.trace("NI_PONG received\n");
        } else {
            this.trace("no NI_PONG received\n");
            m.dump();
        }
    }

    public void trace(int level, String s) {
        if (this.tracelevel >= level) {
            System.out.println(s);
        }
    }

    public void trace(String s) {
        this.trace(2, s);
    }

    public void setTracelevel(int level) {
        this.tracelevel = level < 1 ? 1 : (this.tracelevel > 3 ? 3 : level);
    }

    public int getTracelevel() {
        return this.tracelevel;
    }
}

