/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.Hint;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.TableReference;

public class UpdateStatement
extends SQLStatement {
    private TableReference table;
    private SetClause[] setClauseList;
    private SearchCondition whereClause = null;
    private Hint[] hints;

    public UpdateStatement(TableReference aTable, SetClause[] aSetClauseList, SearchCondition aWhereClause) {
        this.table = aTable;
        this.setClauseList = aSetClauseList;
        this.whereClause = aWhereClause;
    }

    public UpdateStatement(TableReference aTable, SetClause[] aSetClauseList) {
        this.table = aTable;
        this.setClauseList = aSetClauseList;
    }

    public void accept(SQLVisitor visitor) {
        visitor.setStatemntType(this.getStatementType());
        visitor.visitUpdateStatementBefore(this);
        if (this.table != null) {
            this.table.accept(visitor);
        }
        if (this.setClauseList != null) {
            int i = 0;
            while (i < this.setClauseList.length) {
                if (this.setClauseList[i] != null) {
                    this.setClauseList[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.whereClause != null) {
            this.whereClause.accept(visitor);
        }
        visitor.visitUpdateStatement(this);
    }

    public TableReference getTable() {
        return this.table;
    }

    public SetClause[] getSetClauseList() {
        return this.setClauseList;
    }

    public SearchCondition getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(SearchCondition sc) {
        this.whereClause = sc;
    }

    void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        strBuf.append("UPDATE ");
        this.table.toSqlTxt(expert, strBuf);
        strBuf.append(" SET ");
        this.setClauseList[0].toSqlTxt(expert, strBuf);
        int set_i = 1;
        while (set_i < this.setClauseList.length) {
            strBuf.append(",");
            this.setClauseList[set_i].toSqlTxt(expert, strBuf);
            ++set_i;
        }
        if (this.whereClause != null) {
            strBuf.append(" WHERE ");
            this.whereClause.toSqlTxt(expert, strBuf);
        }
    }

    public void setHints(Hint[] hints) {
        this.hints = hints;
    }

    public int getStatementType() {
        return 8;
    }
}

