/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.StringLiteral;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.ValueExpression;

public class SqlTextExpert {
    protected static final char SINGLEQUOTE = '\'';
    protected static final char DOUBLEQUOTE = '\"';
    protected static final char PERIOD = '.';
    protected static final char LEFT_PAREN = '(';
    protected static final char RIGHT_PAREN = ')';
    private static final SqlTextExpert defaultExpert = new SqlTextExpert();

    public static SqlTextExpert getDefaultExpert() {
        return defaultExpert;
    }

    public final void toDelimitedIdentifier(String name, StringBuffer textBuffer) {
        textBuffer.append('\"');
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            textBuffer.append(c);
            if (c == '\"') {
                textBuffer.append('\"');
            }
            ++i;
        }
        textBuffer.append('\"');
    }

    public final void toQualifiedName(String qualifier, String name, StringBuffer strBuf) {
        if (qualifier != null) {
            this.toDelimitedIdentifier(qualifier, strBuf);
            strBuf.append('.');
        }
        this.toDelimitedIdentifier(name, strBuf);
    }

    public final void toSubquery(Query subquery, StringBuffer strBuf) {
        strBuf.append('(');
        subquery.toSqlTxt(this, strBuf);
        strBuf.append(')');
    }

    public void selectSublistToText(SelectSublist sqlNode, StringBuffer textBuffer) {
        TableReference tableRef = sqlNode.getTableRef();
        ValueExpression value = sqlNode.getValue();
        String aliasName = sqlNode.getAliasName();
        if (tableRef != null) {
            tableRef.toSqlTxt(this, textBuffer);
            textBuffer.append(".*");
        } else if (value != null) {
            value.toSqlTxt(this, textBuffer);
            if (!(aliasName == null || value instanceof ColumnReference && aliasName.equals(((ColumnReference)value).getColumnName()))) {
                textBuffer.append(" ");
                this.toDelimitedIdentifier(aliasName, textBuffer);
            }
        } else {
            throw new IllegalStateException("nonsense node: " + this);
        }
    }

    public void stringLiteralToText(StringLiteral sqlNode, StringBuffer textBuffer) {
        String value = sqlNode.getValue();
        textBuffer.append('\'');
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            textBuffer.append(c);
            if (c == '\'') {
                textBuffer.append('\'');
            }
            ++i;
        }
        textBuffer.append('\'');
    }
}

