/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import java.io.Serializable;

public class SortSpecification
implements Serializable {
    private int index;
    private String columnName;
    private boolean descending;

    public SortSpecification(String aColumnName) {
        this.index = 0;
        this.columnName = aColumnName;
        this.descending = false;
    }

    public SortSpecification(String aColumnName, boolean isDescending) {
        this.index = 0;
        this.columnName = aColumnName;
        this.descending = isDescending;
    }

    public SortSpecification(int anIndex, String aColumnName, boolean isDescending) {
        this.index = anIndex;
        this.columnName = aColumnName;
        this.descending = isDescending;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitSortSpecificationBefore(this);
        visitor.visitSortSpecification(this);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public int getIndex() {
        return this.index;
    }

    void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        if (this.index != 0) {
            strBuf.append("" + this.index);
        } else {
            expert.toDelimitedIdentifier(this.columnName, strBuf);
        }
        if (this.descending) {
            strBuf.append(" DESC");
        }
    }
}

