/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.NonJoinQuery;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;

public class JoinedTable
extends Query {
    public static final int CROSS_JOIN = 1;
    public static final int UNION_JOIN = 2;
    public static final int INNER_JOIN = 3;
    public static final int NATURAL_INNER_JOIN = 4;
    public static final int LEFT_OUTER_JOIN = 5;
    public static final int NATURAL_LEFT_OUTER_JOIN = 6;
    public static final int RIGHT_OUTER_JOIN = 7;
    public static final int NATURAL_RIGHT_OUTER_JOIN = 8;
    public static final int FULL_OUTER_JOIN = 9;
    public static final int NATURAL_FULL_OUTER_JOIN = 10;
    private Query leftOperand;
    private Query rightOperand;
    private int joinType;
    private SearchCondition joinCondition = null;
    private String[] namedColumns = null;

    public JoinedTable(Query theLeftOperand, int aJoinType, Query theRightOperand) {
        this.leftOperand = theLeftOperand;
        this.joinType = aJoinType;
        this.rightOperand = theRightOperand;
    }

    public JoinedTable(Query theLeftOperand, int aJoinType, Query theRightOperand, SearchCondition aJoinCondition) {
        this.leftOperand = theLeftOperand;
        this.joinType = aJoinType;
        this.rightOperand = theRightOperand;
        this.joinCondition = aJoinCondition;
    }

    public JoinedTable(Query theLeftOperand, int aJoinType, Query theRightOperand, String[] aNamedColumnList) {
        this.leftOperand = theLeftOperand;
        this.joinType = aJoinType;
        this.rightOperand = theRightOperand;
        this.namedColumns = aNamedColumnList;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitJoinedTableBefore(this);
        if (this.leftOperand != null) {
            this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null) {
            this.rightOperand.accept(visitor);
        }
        if (this.joinCondition != null) {
            this.joinCondition.accept(visitor);
        }
        visitor.visitJoinedTable(this);
    }

    public Query getLeftOperand() {
        return this.leftOperand;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public Query getRightOperand() {
        return this.rightOperand;
    }

    public SearchCondition getJoinCondition() {
        return this.joinCondition;
    }

    public String[] getNamedColumns() {
        return this.namedColumns;
    }

    public void setJoinCondition(SearchCondition sc) {
        this.joinCondition = sc;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        if (this.leftOperand instanceof NonJoinQuery) {
            strBuf.append("(");
        }
        this.leftOperand.toSqlTxt(expert, strBuf);
        if (this.leftOperand instanceof NonJoinQuery) {
            strBuf.append(")");
        }
        switch (this.joinType) {
            case 1: {
                strBuf.append(" CROSS JOIN ");
                break;
            }
            case 9: {
                strBuf.append(" FULL OUTER JOIN ");
                break;
            }
            case 3: {
                strBuf.append(" INNER JOIN ");
                break;
            }
            case 5: {
                strBuf.append(" LEFT OUTER JOIN ");
                break;
            }
            case 7: {
                strBuf.append(" RIGHT OUTER JOIN ");
                break;
            }
            case 2: {
                strBuf.append(" UNION JOIN ");
                break;
            }
            case 10: {
                strBuf.append(" NATURAL FULL OUTER JOIN ");
                break;
            }
            case 4: {
                strBuf.append(" NATURAL INNER JOIN ");
                break;
            }
            case 6: {
                strBuf.append(" NATURAL LEFT OUTER JOIN ");
                break;
            }
            case 8: {
                strBuf.append(" NATURAL_RIGHT OUTER JOIN ");
                break;
            }
        }
        if (this.rightOperand instanceof JoinedTable || this.rightOperand instanceof NonJoinQuery) {
            strBuf.append("(");
        }
        this.rightOperand.toSqlTxt(expert, strBuf);
        if (this.rightOperand instanceof JoinedTable || this.rightOperand instanceof NonJoinQuery) {
            strBuf.append(")");
        }
        if (this.joinCondition != null) {
            strBuf.append(" ON ");
            this.joinCondition.toSqlTxt(expert, strBuf);
        } else if (this.namedColumns != null && this.namedColumns.length > 0) {
            strBuf.append(" USING ");
            strBuf.append(this.namedColumns[0]);
            int i = 1;
            while (i < this.namedColumns.length) {
                strBuf.append(",");
                strBuf.append(this.namedColumns[i]);
                ++i;
            }
        }
    }
}

