/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.ValueExpression;

public class ConcatenationExpression
extends ValueExpression {
    private ValueExpression[] operands;

    public ConcatenationExpression(ValueExpression[] anOperandList) {
        this.operands = anOperandList;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitConcatenationExpressionBefore(this);
        if (this.operands != null) {
            int i = 0;
            while (i < this.operands.length) {
                if (this.operands[i] != null) {
                    this.operands[i].accept(visitor);
                }
                ++i;
            }
        }
        visitor.visitConcatenationExpression(this);
    }

    public ValueExpression[] getOperands() {
        return this.operands;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        if (this.operands != null && this.operands.length > 0) {
            this.operands[0].toSqlTxt(expert, strBuf);
            int i = 1;
            while (i < this.operands.length) {
                strBuf.append(" || ");
                this.operands[i].toSqlTxt(expert, strBuf);
                ++i;
            }
        }
    }
}

