/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.Literal;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import java.math.BigDecimal;

public class BigDecimalLiteral
extends Literal {
    private BigDecimal value;
    private ResultDescriptor result;

    public BigDecimalLiteral(BigDecimal aValue) {
        this.value = aValue;
        int precision = this.value.abs().unscaledValue().toString().length();
        this.result = new ResultDescriptor(3, (long)precision, this.value.scale(), true);
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitBigDecimalLiteralBefore(this);
        visitor.visitBigDecimalLiteral(this);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        strBuf.append(this.value.toString());
    }

    public String toString() {
        return this.value.toString();
    }

    public ResultDescriptor getResultDescriptor() {
        return this.result;
    }
}

