/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.services;

import com.sap.sql.buffer.monitor.BufferMonitor;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.monitor.CatalogBufferMonitor;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.DatabaseVendor;
import com.sap.sql.jdbc.ServiceConnection;
import com.sap.sql.jdbc.VMContext;
import com.sap.sql.jdbc.common.CommonConnection;
import com.sap.sql.jdbc.common.CreateViewStatementAnalyzer;
import com.sap.sql.jdbc.common.StatementAnalyzer;
import com.sap.sql.jdbc.monitor.ConnectionMonitor;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.DatabaseInformation;
import com.sap.sql.services.OpenSQLServicesSpi;
import com.sap.sql.tree.SQLStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class OpenSQLServices {
    public static final int VENDOR_UNKNOWN = -1;
    public static final int VENDOR_DB2_UDB = 0;
    public static final int VENDOR_DB2_UDB_AS400 = 1;
    public static final int VENDOR_DB2_UDB_OS390 = 2;
    public static final int VENDOR_INFORMIX = 3;
    public static final int VENDOR_MS_SQL_SERVER = 4;
    public static final int VENDOR_ORACLE = 5;
    public static final int VENDOR_SAPDB = 6;
    public static final int SQL_TYPE_OPEN_SQL = 1;
    public static final int SQL_TYPE_NATIVE_SQL = 2;
    public static final int SQL_TYPE_VENDOR_SQL = 3;
    private static final String implementation = "com.sap.sql.services.OpenSQLServicesImpl";
    private static OpenSQLServicesSpi services;
    static /* synthetic */ Class class$com$sap$sql$services$OpenSQLServices;

    private OpenSQLServices() {
    }

    public static void setServices(OpenSQLServicesSpi services) {
        OpenSQLServices.services = services;
    }

    public static DatabaseMetaData getNativeMetaData(Connection connection) throws SQLException {
        return connection instanceof CommonConnection ? ((CommonConnection)connection).getDirectMetaData() : connection.getMetaData();
    }

    public static Statement createNativeStatement(Connection connection) throws SQLException {
        return connection instanceof CommonConnection ? ((CommonConnection)connection).createDirectStatement() : connection.createStatement();
    }

    public static Statement createNativeStatement(Connection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        return connection instanceof CommonConnection ? ((CommonConnection)connection).createDirectStatement(resultSetType, resultSetConcurrency) : connection.createStatement(resultSetType, resultSetConcurrency);
    }

    public static PreparedStatement prepareNativeStatement(Connection connection, String sql) throws SQLException {
        return connection instanceof CommonConnection ? ((CommonConnection)connection).prepareDirectStatement(sql) : connection.prepareStatement(sql);
    }

    public static PreparedStatement prepareNativeStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return connection instanceof CommonConnection ? ((CommonConnection)connection).prepareDirectStatement(sql, resultSetType, resultSetConcurrency) : connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public static CallableStatement prepareNativeCall(Connection connection, String sql) throws SQLException {
        return connection instanceof CommonConnection ? ((CommonConnection)connection).prepareDirectCall(sql) : connection.prepareCall(sql);
    }

    public static CallableStatement prepareNativeCall(Connection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return connection instanceof CommonConnection ? ((CommonConnection)connection).prepareDirectCall(sql, resultSetType, resultSetConcurrency) : connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public static int getVendorID(String productName) {
        return DatabaseVendor.getVendorID((String)productName);
    }

    public static int getVendorID(Connection connection) {
        return DatabaseVendor.getVendorID((Connection)connection);
    }

    public static String getVendorName(int vendorID) {
        return DatabaseVendor.getVendorName((int)vendorID);
    }

    public static String getVendorName(Connection connection) {
        return DatabaseVendor.getVendorName((Connection)connection);
    }

    public static String[] getVendorNames() {
        return DatabaseVendor.getVendorNames();
    }

    public static String getVendorTitle(int vendorID) {
        return DatabaseVendor.getVendorTitle((int)vendorID);
    }

    public static int getSQLType(Connection connection) throws SQLException {
        if (!(connection instanceof ServiceConnection)) {
            return 3;
        }
        ConnectionContext context = (ConnectionContext)((ServiceConnection)connection).getServiceContext();
        return context.isCommonSQL() ? 1 : 2;
    }

    public static Timestamp getUTCTimestamp(Connection connection) throws SQLException {
        if (!(connection instanceof ServiceConnection)) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$services$OpenSQLServices == null ? (class$com$sap$sql$services$OpenSQLServices = OpenSQLServices.class$("com.sap.sql.services.OpenSQLServices")) : class$com$sap$sql$services$OpenSQLServices), (String)"com.sap.sql_0008", (Object[])new Object[]{connection.getClass().getName()});
        }
        ConnectionContext context = (ConnectionContext)((ServiceConnection)connection).getServiceContext();
        return OpenSQLServices.getServices().getUTCTimestamp(context);
    }

    public static String getConnectionID(Connection connection) throws SQLException {
        if (!(connection instanceof ServiceConnection)) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$services$OpenSQLServices == null ? (class$com$sap$sql$services$OpenSQLServices = OpenSQLServices.class$("com.sap.sql.services.OpenSQLServices")) : class$com$sap$sql$services$OpenSQLServices), (String)"com.sap.sql_0008", (Object[])new Object[]{connection.getClass().getName()});
        }
        ConnectionContext context = (ConnectionContext)((ServiceConnection)connection).getServiceContext();
        return OpenSQLServices.getServices().getConnectionID(context);
    }

    public static void invalidateTable(Connection connection, String tableName) throws SQLException {
        if (!(connection instanceof ServiceConnection)) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$services$OpenSQLServices == null ? (class$com$sap$sql$services$OpenSQLServices = OpenSQLServices.class$("com.sap.sql.services.OpenSQLServices")) : class$com$sap$sql$services$OpenSQLServices), (String)"com.sap.sql_0008", (Object[])new Object[]{connection.getClass().getName()});
        }
        ConnectionContext context = (ConnectionContext)((ServiceConnection)connection).getServiceContext();
        OpenSQLServices.getServices().invalidateTable(context, tableName);
    }

    public static void resetCatalogBuffer(Connection connection) throws SQLException {
        if (!(connection instanceof ServiceConnection)) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$services$OpenSQLServices == null ? (class$com$sap$sql$services$OpenSQLServices = OpenSQLServices.class$("com.sap.sql.services.OpenSQLServices")) : class$com$sap$sql$services$OpenSQLServices), (String)"com.sap.sql_0008", (Object[])new Object[]{connection.getClass().getName()});
        }
        ConnectionContext context = (ConnectionContext)((ServiceConnection)connection).getServiceContext();
        OpenSQLServices.getServices().resetCatalogBuffer(context);
    }

    public static boolean isSQLKeyword(String key) {
        return OpenSQLServices.getServices().isSQLKeyword(key);
    }

    public static DatabaseInformation getDatabaseInformation(String dataSourceName) {
        return OpenSQLServices.getServices().getDatabaseInformation(dataSourceName);
    }

    public static DatabaseInformation getDatabaseInformation(Connection connection) throws SQLException {
        if (!(connection instanceof ServiceConnection)) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$services$OpenSQLServices == null ? (class$com$sap$sql$services$OpenSQLServices = OpenSQLServices.class$("com.sap.sql.services.OpenSQLServices")) : class$com$sap$sql$services$OpenSQLServices), (String)"com.sap.sql_0008", (Object[])new Object[]{connection.getClass().getName()});
        }
        ConnectionContext context = (ConnectionContext)((ServiceConnection)connection).getServiceContext();
        return OpenSQLServices.getServices().getDatabaseInformation(context);
    }

    public static BufferMonitor getBufferMonitor() {
        return OpenSQLServices.getServices().getBufferMonitor();
    }

    public static CatalogBufferMonitor getCatalogBufferMonitor() {
        return OpenSQLServices.getServices().getCatalogBufferMonitor();
    }

    public static ConnectionMonitor getConnectionMonitor() {
        return OpenSQLServices.getServices().getConnectionMonitor();
    }

    public static Object getSqljConnectionContext(CommonConnection connection, SQLStatement stmt) throws SQLException {
        ConnectionContext context = (ConnectionContext)connection.getServiceContext();
        return OpenSQLServices.getServices().getSqljConnectionContext(context, stmt);
    }

    public static Object getRTResultSet(ResultSet resultSet) {
        return OpenSQLServices.getServices().getRTResultSet(resultSet);
    }

    public static CreateViewStatementAnalyzer getCreateViewStatementAnalyzer(CommonConnection connection) throws SQLException {
        ConnectionContext context = (ConnectionContext)connection.getServiceContext();
        return OpenSQLServices.getServices().getCreateViewStatementAnalyzer(context);
    }

    public static CreateViewStatementAnalyzer getCreateViewStatementAnalyzer(CatalogReader reader) {
        return OpenSQLServices.getServices().getCreateViewStatementAnalyzer(reader);
    }

    public static StatementAnalyzer getStatementAnalyzer(CommonConnection connection) throws SQLException {
        ConnectionContext context = (ConnectionContext)connection.getServiceContext();
        return OpenSQLServices.getServices().getStatementAnalyzer(context);
    }

    public static StatementAnalyzer createStatementAnalyzer() {
        return OpenSQLServices.getServices().createStatementAnalyzer();
    }

    public static CatalogReader getCatalogReader(CommonConnection connection) throws SQLException {
        ConnectionContext context = (ConnectionContext)connection.getServiceContext();
        return OpenSQLServices.getServices().getCatalogReader(context);
    }

    public static boolean isTransientSQLError(Connection connection, SQLException exception) throws SQLException {
        if (!(connection instanceof ServiceConnection)) {
            throw Syslog.createAndLogOpenSQLException((Class)(class$com$sap$sql$services$OpenSQLServices == null ? (class$com$sap$sql$services$OpenSQLServices = OpenSQLServices.class$("com.sap.sql.services.OpenSQLServices")) : class$com$sap$sql$services$OpenSQLServices), (String)"com.sap.sql_0008", (Object[])new Object[]{connection.getClass().getName()});
        }
        ConnectionContext context = (ConnectionContext)((ServiceConnection)connection).getServiceContext();
        return OpenSQLServices.getServices().isTransientSQLError(context, exception);
    }

    public static void trySettingExecutionContextViaBatch(Object connCtx) {
        OpenSQLServices.getServices().trySettingExecutionContextViaBatch(connCtx);
    }

    private static OpenSQLServicesSpi getServices() {
        if (services != null) {
            return services;
        }
        if (VMContext.isJ2EEServerActive()) {
            throw new IllegalStateException("Open SQL service initialization by J2EE server failed");
        }
        try {
            services = (OpenSQLServicesSpi)Class.forName(implementation).newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Open SQL service initialization for standalone program failed");
        }
        return services;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

