/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl.sampleData;

import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.connector.IBIOlapObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.olap.BITreeOperator;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.analysis.olap.LevelBasedHierarchy;
import org.omg.cwm.analysis.olap.Schema;
import org.omg.cwm.objectmodel.core.Attribute;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.objectmodel.core.TaggedValue;

public class FindMetadata {
    private final IBIOlap olap;
    private final IBIOlapObjectFinder finder;
    private static final Set MANDATORY_PROPERTIES = new HashSet<Object>(Arrays.asList("MEMBER_UNIQUE_NAME", "MEMBER_NAME", "MEMBER_CAPTION", "CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_NUMBER", "MEMBER_TYPE", "MEMBER_GUID", "MEMBER_ORDINAL", "CHILDREN_CARDINALITY", "PARENT_LEVEL", "PARENT_UNIQUE_NAME", "PARENT_COUNT", "DESCRIPTION"));

    public FindMetadata(IBIOlap olap) throws Exception {
        this.olap = olap;
        this.finder = olap.getObjectFinder();
    }

    public Cube getCube(String cubeName) {
        Cube cube = null;
        try {
            cube = this.finder.findCubeFirst((Schema)null, cubeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cube;
    }

    public Dimension getDimension(String cubeName, String dimensionName) {
        Dimension dimension = null;
        try {
            dimension = this.finder.findDimensionFirst(null, cubeName, dimensionName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return dimension;
    }

    public LevelBasedHierarchy getLevelBasedHierarchy(String cubeName, String dimensionName, String hierarchyName) {
        LevelBasedHierarchy levelBasedHierarchy = null;
        try {
            levelBasedHierarchy = this.finder.findHierarchyFirst(null, cubeName, dimensionName, hierarchyName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return levelBasedHierarchy;
    }

    public Level getLevel(String cubeName, String dimensionName, String levelName) {
        Level level = null;
        try {
            level = this.finder.findLevelFirst(null, cubeName, dimensionName, null, levelName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return level;
    }

    public IBIMember getMember(String cubeName, String dimensionName, String memberName) {
        IBIMember member = null;
        try {
            member = this.finder.findMemberFirst(null, cubeName, dimensionName, null, null, memberName, BITreeOperator.SELF);
        }
        catch (Exception e) {
            // empty catch block
        }
        return member;
    }

    public IBIMember getMember(String cubeName, String dimensionName, String levelName, String memberName, String memberUniqueName) {
        IBIMember member = null;
        try {
            List members = this.finder.findMember(null, cubeName, dimensionName, null, levelName, memberName, BITreeOperator.SELF);
            member = (IBIMember)this.getByTaggedValue(members, "MEMBER_UNIQUE_NAME", memberUniqueName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return member;
    }

    public Attribute getAttribute(String cubeName, String dimensionName, String attributeName) {
        Attribute attribute = null;
        try {
            Dimension dimension = this.finder.findDimensionFirst(null, cubeName, dimensionName);
            Iterator i = dimension.getFeature().iterator();
            while (i.hasNext()) {
                Attribute loopAttribute = (Attribute)i.next();
                if (!loopAttribute.getName().equals(attributeName)) continue;
                attribute = loopAttribute;
                break;
            }
            if (MANDATORY_PROPERTIES.contains(attributeName)) {
                attribute = this.olap.getQueryFactory().getMetadataFactory().createAttribute(attributeName, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return attribute;
    }

    private ModelElement getByTaggedValue(Collection objects, String tag, String value) {
        Iterator i = objects.iterator();
        block2: while (i.hasNext()) {
            ModelElement modelElement = (ModelElement)i.next();
            Collection taggedValues = null;
            try {
                taggedValues = this.olap.getTaggedValue(modelElement);
            }
            catch (Exception e) {
                // empty catch block
            }
            Iterator j = taggedValues.iterator();
            while (j.hasNext()) {
                TaggedValue taggedValue = (TaggedValue)j.next();
                if (!taggedValue.getTag().equals(tag)) continue;
                if (!taggedValue.getValue().equals(value)) continue block2;
                return modelElement;
            }
        }
        return null;
    }
}

