/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DataContainer {
    static final int MAX_TABLES = 5;
    private Connection _connection = null;
    private Vector _tables = new Vector();
    private Statement _statment = null;

    public DataContainer(String dbURL, String driver, String user, String passwd) {
        try {
            if (this.setNewConnection(dbURL, driver, user, passwd)) {
                DatabaseMetaData dbMetaData = this._connection.getMetaData();
                this._statment = this._connection.createStatement();
                this.removeAll();
                String[] usertables = new String[]{"TABLE"};
                ResultSet result = dbMetaData.getTables(null, null, null, usertables);
                while (result.next()) {
                    this._tables.addElement(result.getString(3));
                }
                result.close();
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public boolean setNewConnection(String dbURL, String driver, String user, String passWord) throws SQLException {
        try {
            if (this._connection != null) {
                this._connection.close();
            }
            Class.forName(driver);
            this._connection = DriverManager.getConnection(dbURL, user, passWord);
            if (this._connection == null) {
                System.out.println("Cannot connect to the database: " + dbURL);
                throw new SQLException();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void closeConnection() throws SQLException {
        if (this._connection != null) {
            this._connection.close();
        }
    }

    public int getTablesCount() {
        return this._tables.size();
    }

    public void removeTable(int index) throws SQLException {
        String tableName = (String)this._tables.elementAt(index);
        this._statment.executeUpdate("DROP TABLE " + tableName);
        this._tables.remove(index);
    }

    public void removeAll() throws SQLException {
        int i = 0;
        while (i < this.getTablesCount()) {
            String tableName = (String)this._tables.elementAt(i);
            this._statment.executeUpdate("DROP TABLE " + tableName);
            this._tables.remove(i);
            ++i;
        }
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String getTable(int index) {
        return (String)this._tables.elementAt(index);
    }

    public String[] getTables() {
        if (this._tables.size() > 0) {
            String[] names = new String[this._tables.size()];
            int i = 0;
            while (i < this._tables.size()) {
                names[i] = (String)this._tables.elementAt(i);
                ++i;
            }
            return names;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addTable(File dataFile, File sqlFile, char delimeter) throws SQLException {
        FileInputStream inputFile;
        int columnCount = 1;
        String columns = "(";
        String columnDymn = "(";
        String tableName = null;
        String sqlString = "";
        String line = null;
        String processLine = null;
        tableName = dataFile.getName().substring(0, dataFile.getName().indexOf(46)).toUpperCase();
        try {
            inputFile = new FileInputStream(sqlFile);
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + sqlFile.getName() + " could not be found");
            return;
        }
        try {
            this._statment.executeUpdate("DROP TABLE " + tableName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        int i = 0;
        i = 0;
        while (i < this.getTablesCount()) {
            if (this.getTable(i).toUpperCase() == tableName) break;
            ++i;
        }
        if (i == this.getTablesCount()) {
            this._tables.add(tableName);
        }
        try {
            int positionOnString;
            DataInputStream inputStream = new DataInputStream(inputFile);
            while ((line = inputStream.readLine()) != null) {
                sqlString = sqlString + line.trim();
                while ((positionOnString = line.indexOf(44)) >= 0 && line.length() != 0) {
                    void var11_16;
                    ++columnCount;
                    line = line.substring((int)(var11_16 + true));
                }
            }
            columnDymn = "(";
            i = 1;
            while (i < columnCount) {
                columnDymn = columnDymn + "?";
                ++i;
                columnDymn = columnDymn + ",";
            }
            this._statment.execute(sqlString);
            this._statment.close();
            CallableStatement prep = this._connection.prepareCall("INSERT INTO " + tableName + " VALUES " + columnDymn + "?)");
            try {
                inputFile = new FileInputStream(dataFile);
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + dataFile.getName() + " could not be found");
                return;
            }
            inputStream = new DataInputStream(inputFile);
            while ((line = inputStream.readLine()) != null) {
                processLine = line;
                prep.clearParameters();
                i = 1;
                while (i <= columnCount) {
                    positionOnString = processLine.indexOf(delimeter);
                    if (positionOnString >= 0) {
                        prep.setString(i, processLine.substring(0, positionOnString));
                    } else {
                        prep.setString(i, processLine);
                    }
                    processLine = processLine.substring(positionOnString + 1);
                    ++i;
                }
                prep.executeUpdate();
            }
            prep.close();
        }
        catch (IOException e) {
            System.err.println("Error reading/writing.");
        }
    }

    public ResultSet getResultset(String SQLStatement) throws SQLException {
        Statement stat = this._connection.createStatement();
        return stat.executeQuery(SQLStatement);
    }
}

