/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.exception.BIResourceException;

public class BISqlAbapType {
    private static final String SMALLINT = "short";
    private static final String VARCHAR = "java.lang.String";
    private static final String LONGVARCHAR = "java.lang.String";
    private static final String DATE = "java.sql.Date";
    private static final String DOUBLE = "double";
    private static final String INTEGER = "int";
    private static final String BIGINT = "java.math.BigDecimal";
    private static final String TIME = "java.sql.Time";
    private static final String VARBINARY = "byte[]";
    private static final String ABAP = "ABAP/4";
    private static final String SQL = "java.sql.Types";
    private static final char ABAP_TYPE_CHARACTER = 'C';
    private static final char ABAP_TYPE_NUMERIC = 'N';
    private static final char ABAP_TYPE_DATE = 'D';
    private static final char ABAP_TYPE_TIME = 'T';
    private static final char ABAP_TYPE_BYTE = 'X';
    private static final char ABAP_TYPE_INT = 'I';
    private static final char ABAP_TYPE_INT1 = 'b';
    private static final char ABAP_TYPE_INT2 = 's';
    private static final char ABAP_TYPE_BCD = 'P';
    private static final char ABAP_TYPE_FLOAT = 'F';
    private static final char ABAP_TYPE_STRING = 'g';
    private static final char ABAP_TYPE_XSTRING = 'y';
    private static final IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    public static int getJCOTypefromABAP(char type) throws BIResourceException {
        switch (type) {
            case 'C': {
                return 0;
            }
            case 'N': {
                return 6;
            }
            case 'D': {
                return 1;
            }
            case 'T': {
                return 3;
            }
            case 'X': {
                return 4;
            }
            case 'I': {
                return 8;
            }
            case 'b': {
                return 10;
            }
            case 's': {
                return 9;
            }
            case 'P': {
                return 2;
            }
            case 'F': {
                return 7;
            }
            case 'g': {
                return 29;
            }
            case 'y': {
                return 30;
            }
        }
        throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector_1002", new Object[]{ABAP, new Character(type)});
    }

    private BISqlAbapType() {
    }

    public static int getSqlTypeFromAbap(String abapType) throws BIResourceException {
        if (abapType == null || abapType.length() < 1) {
            throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector_1002", new Object[]{ABAP, abapType});
        }
        return BISqlAbapType.getSqlTypeFromAbap(abapType.charAt(0));
    }

    public static int getSqlTypeFromAbap(char abapType) throws BIResourceException {
        switch (abapType) {
            case 'b': {
                return 5;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 91;
            }
            case 'F': {
                return 8;
            }
            case 'g': {
                return -1;
            }
            case 'I': {
                return 4;
            }
            case 'N': {
                return 12;
            }
            case 'P': {
                return 3;
            }
            case 's': {
                return 5;
            }
            case 'T': {
                return 92;
            }
            case 'X': {
                return -3;
            }
            case 'y': {
                return -3;
            }
        }
        throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector_1002", new Object[]{ABAP, new Character(abapType)});
    }

    public static String getSQLTypeNameFromAbap(String abapType) throws BIResourceException {
        if (abapType == null || abapType.length() < 1) {
            throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector_1002", new Object[]{ABAP, abapType});
        }
        return BISqlAbapType.getSQLTypeNameFromAbap(abapType.charAt(0));
    }

    public static String getSQLTypeNameFromAbap(char abapType) throws BIResourceException {
        switch (abapType) {
            case 'b': {
                return SMALLINT;
            }
            case 'C': {
                return "java.lang.String";
            }
            case 'D': {
                return DATE;
            }
            case 'F': {
                return DOUBLE;
            }
            case 'g': {
                return "java.lang.String";
            }
            case 'I': {
                return INTEGER;
            }
            case 'N': {
                return "java.lang.String";
            }
            case 'P': {
                return BIGINT;
            }
            case 's': {
                return SMALLINT;
            }
            case 'T': {
                return TIME;
            }
            case 'X': {
                return VARBINARY;
            }
            case 'y': {
                return VARBINARY;
            }
        }
        throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector_1002", new Object[]{ABAP, new Character(abapType)});
    }

    public static char getABAPTypeFromSQLType(int sqlType) throws BIResourceException {
        switch (sqlType) {
            case -6: {
                return 'b';
            }
            case 5: {
                return 's';
            }
            case 4: {
                return 'I';
            }
            case -5: {
                return 'N';
            }
            case 1: 
            case 12: {
                return 'C';
            }
            case -1: {
                return 'g';
            }
            case 6: 
            case 7: 
            case 8: {
                return 'F';
            }
            case 2: {
                return 'N';
            }
            case 3: {
                return 'P';
            }
            case 92: 
            case 93: {
                return 'T';
            }
            case 91: {
                return 'D';
            }
            case -4: 
            case -3: 
            case -2: {
                return 'y';
            }
        }
        throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector_1002", new Object[]{SQL, new Integer(sqlType)});
    }
}

