/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.exception.BIException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class BISqlAbapTimestamp {
    private static final String EPOCH = "19700101";
    private static final DecimalFormat DEC4 = new DecimalFormat("0000");
    private static final DecimalFormat DEC2 = new DecimalFormat("00");
    private static final FieldPosition POS = new FieldPosition(0);
    private Calendar cal = null;
    private static final IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    public BISqlAbapTimestamp() {
        this.cal = new GregorianCalendar();
    }

    public BISqlAbapTimestamp(TimeZone tz, Locale locale) {
        this.cal = new GregorianCalendar(tz, locale);
    }

    public String getAbapDateFromEpoch(long millis) throws BIException {
        if (millis < 0L) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        this.cal.clear();
        this.cal.setTime(new Date(millis));
        int year = this.cal.get(1);
        int month = this.cal.get(2) + 1;
        int day = this.cal.get(5);
        StringBuffer abap = new StringBuffer();
        abap = DEC4.format((long)year, abap, POS);
        abap = DEC2.format((long)month, abap, POS);
        abap = DEC2.format((long)day, abap, POS);
        return abap.toString();
    }

    public String getAbapDateFromEpoch(Date date) throws BIException {
        if (date == null) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        return this.getAbapDateFromEpoch(date.getTime());
    }

    public String getAbapDateFromSQLTimeStamp(String sqlTime) throws BIException {
        if (sqlTime == null) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        StringBuffer abap = new StringBuffer();
        abap.append(sqlTime.substring(0, 4));
        abap.append(sqlTime.substring(5, 7));
        abap.append(sqlTime.substring(8, 10));
        return abap.toString();
    }

    public String getAbapTimeFromSQLTime(String sqlTime) throws BIException {
        if (sqlTime == null) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        StringBuffer abap = new StringBuffer();
        abap.append(sqlTime.substring(0, 2));
        abap.append(sqlTime.substring(3, 5));
        abap.append(sqlTime.substring(6));
        return abap.toString();
    }

    public String getSQLTimeFromABAPTime(String abapTime) throws BIException {
        if (abapTime == null) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        StringBuffer sqlTime = new StringBuffer();
        sqlTime.append(abapTime.substring(0, 2));
        sqlTime.append(':');
        sqlTime.append(abapTime.substring(2, 4));
        sqlTime.append(':');
        sqlTime.append(abapTime.substring(4));
        return sqlTime.toString();
    }

    public String getAbapDateTimeFromEpoch(long millis) throws BIException {
        if (millis < 0L) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        this.cal.clear();
        this.cal.setTime(new Date(millis));
        int year = this.cal.get(1);
        int month = this.cal.get(2) + 1;
        int day = this.cal.get(5);
        int hour = this.cal.get(11);
        int minute = this.cal.get(12);
        int second = this.cal.get(13);
        StringBuffer abap = new StringBuffer();
        abap = DEC4.format((long)year, abap, POS);
        abap = DEC2.format((long)month, abap, POS);
        abap = DEC2.format((long)day, abap, POS);
        abap = DEC2.format((long)hour, abap, POS);
        abap = DEC2.format((long)minute, abap, POS);
        abap = DEC2.format((long)second, abap, POS);
        return abap.toString();
    }

    public long getEpochFromAbapDate(String abapDate) throws BIException {
        if (abapDate == null || abapDate.length() != 8) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            year = Integer.parseInt(abapDate.substring(0, 4));
            month = Integer.parseInt(abapDate.substring(4, 6)) - 1;
            day = Integer.parseInt(abapDate.substring(6));
        }
        catch (NumberFormatException ex) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        return this.getEpoch(year, month, day);
    }

    public long getEpochFromAbapDateTime(String abapDate) throws BIException {
        if (abapDate == null || abapDate.length() != 8 && abapDate.length() != 14) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            year = Integer.parseInt(abapDate.substring(0, 4));
            month = Integer.parseInt(abapDate.substring(4, 6)) - 1;
            if (abapDate.length() == 14) {
                day = Integer.parseInt(abapDate.substring(6, 8));
                hour = Integer.parseInt(abapDate.substring(8, 10));
                minute = Integer.parseInt(abapDate.substring(10, 12));
                second = Integer.parseInt(abapDate.substring(12));
            } else {
                day = Integer.parseInt(abapDate.substring(6));
            }
        }
        catch (NumberFormatException ex) {
            throw new BIException(connectionInfo.getLocale(), "sdk.util_2000");
        }
        return this.getEpoch(year, month, day, hour, minute, second);
    }

    private long getEpoch(int year, int month, int day) {
        return this.getEpoch(year, month, day, 0, 0, 0);
    }

    private long getEpoch(int year, int month, int day, int hour, int minute, int second) {
        this.cal.clear();
        this.cal.set(1, year);
        this.cal.set(2, month);
        this.cal.set(5, day);
        this.cal.set(11, hour);
        this.cal.set(12, minute);
        this.cal.set(13, second);
        return this.cal.getTime().getTime();
    }
}

