/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class BIResourceProperties
extends Properties {
    private static final String EMPTY = "";
    private static HashMap file = new HashMap();

    private BIResourceProperties() {
    }

    private BIResourceProperties(Properties defaults) {
        super(defaults);
    }

    public BIResourceProperties(Class object) {
        this.loadProperties(object, EMPTY);
    }

    public BIResourceProperties(Class object, String suffix) {
        this.loadProperties(object, suffix);
    }

    public BIResourceProperties(Class object, Properties defaults) {
        super(defaults);
        this.loadProperties(object, EMPTY);
    }

    public BIResourceProperties(Class object, Properties defaults, String suffix) {
        super(defaults);
        this.loadProperties(object, suffix);
    }

    public static void setFile(Class object, String propertiesFile) {
        BIResourceProperties.assertNotNull(object);
        if (propertiesFile == null) {
            file.remove(object.getName());
        } else {
            file.put(object.getName(), propertiesFile);
        }
    }

    private void loadProperties(Class object, String suffix) {
        BIResourceProperties.assertNotNull(object);
        try {
            String propFile = this.classDirectory(object) + this.fileSeparator() + this.classFileName(object) + suffix + ".properties";
            InputStream propStream = this.getClass().getClassLoader().getResourceAsStream(propFile);
            if (propStream != null) {
                this.load(propStream);
            }
            propFile = this.classDirectory(object) + this.fileSeparator() + this.classFileName(object) + suffix + ".local.properties";
            propStream = object.getClassLoader().getResourceAsStream(propFile);
            if (propStream != null) {
                this.load(propStream);
            }
            if (file.containsKey(object.getName())) {
                String fileName = (String)file.get(object.getName());
                try {
                    propStream = new FileInputStream(new File(fileName));
                    this.load(propStream);
                }
                catch (FileNotFoundException ex) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String classDirectory(Class object) {
        String className = object.getName();
        String packageName = className.substring(0, className.lastIndexOf(46));
        char sep = this.fileSeparator();
        return packageName.replace('.', sep);
    }

    private String classFileName(Class object) {
        String className = object.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private char fileSeparator() {
        return '/';
    }

    private static void assertNotNull(Object object) {
        if (object == null) {
            throw new BIRuntimeException(IBIConnectionInfo.DEFAULT.getLocale(), "sdk_4000", new Object[]{"Class"});
        }
    }
}

