/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BISatCheck;
import com.sap.ip.bi.sdk.util.impl.BICache;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.RequestOverview;
import com.sap.util.monitor.jarm.TaskMonitor;
import com.sap.util.monitor.jarm.sat.ISatCheck;
import com.sap.util.monitor.jarm.sat.SatCheckHandler;

public class BIMonitor
implements IBIMonitor {
    static final char REQUEST_SEPARATOR = ':';
    static final char CLASS_SEPARATOR = '.';
    static final String SDK_REQUEST_PREFIX = "BI:SDK:";
    static final String SDK_CLASS_PREFIX = "com.sap.ip.sdk";
    private IBIMonitor.Request request = null;
    private String user = null;
    private IMonitor monitor;
    private boolean isInRequest = false;
    private static int CACHE_SIZE = 100;
    private static int FILL_PERCENTAGE = 90;
    private static BICache cache = new BICache(CACHE_SIZE, FILL_PERCENTAGE);
    private BISatCheck satCheck;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    private BIMonitor(IBIMonitor.User user) {
        this.user = user.toString();
        this.satCheck = new BISatCheck(this.user);
        SatCheckHandler.registerSatCheck((ISatCheck)this.satCheck);
    }

    private BIMonitor(IBIConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.assertConnectionInfo();
        this.user = connectionInfo.getUser();
        this.satCheck = new BISatCheck(this.user);
        SatCheckHandler.registerSatCheck((ISatCheck)this.satCheck);
    }

    public static IBIMonitor createMonitor() {
        return new BIMonitor(IBIMonitor.User.DEFAULT);
    }

    public static IBIMonitor createMonitor(IBIMonitor.User user) {
        return new BIMonitor(user);
    }

    public static IBIMonitor createMonitor(IBIConnectionInfo connectionInfo) {
        return new BIMonitor(connectionInfo);
    }

    public static IBIMonitor createMonitor(IBIMonitor.Request request) {
        BIMonitor m = new BIMonitor(IBIMonitor.User.DEFAULT);
        m.startRequest(request);
        return m;
    }

    public static IBIMonitor createMonitor(IBIMonitor.User user, IBIMonitor.Request request) {
        BIMonitor m = new BIMonitor(user);
        m.startRequest(request);
        return m;
    }

    public static IBIMonitor createMonitor(IBIConnectionInfo connectionInfo, IBIMonitor.Request request) {
        BIMonitor m = new BIMonitor(connectionInfo);
        m.startRequest(request);
        return m;
    }

    public static IBIMonitor retrieveMonitor(Object uniqueKey) {
        return (IBIMonitor)cache.get(uniqueKey);
    }

    public static IBIMonitor removeMonitor(Object uniqueKey) {
        return (IBIMonitor)cache.remove(uniqueKey);
    }

    public void storeMonitor(Object uniqueKey) {
        cache.put(uniqueKey, this);
    }

    public IBIMonitor.Request getCurrentRequest() {
        if (this.isInRequest) {
            return this.request;
        }
        return null;
    }

    public void startRequest(IBIMonitor.Request request) {
        this.startRequestInternal(request);
    }

    public void endRequest(IBIMonitor.Request request) {
        this.assertIsInRequest();
        this.monitor.endRequest(request.toString());
        this.endRequestInternal();
    }

    public void endRequest(IBIMonitor.Request request, int dataLength) {
        this.assertIsInRequest();
        this.monitor.endRequest(request.toString(), dataLength);
        this.endRequestInternal();
    }

    public RequestOverview endRequest(int requestOverview, IBIMonitor.Request request) {
        this.assertIsInRequest();
        RequestOverview r = this.monitor.endRequest(requestOverview, request.toString());
        this.endRequestInternal();
        return r;
    }

    public RequestOverview endRequest(int requestOverview, IBIMonitor.Request reques, int dataLength) {
        this.assertIsInRequest();
        RequestOverview r = this.monitor.endRequest(requestOverview, this.request.toString(), dataLength);
        this.endRequestInternal();
        return r;
    }

    public void startComponent(Class componentClass, String method) {
        this.assertIsInRequest();
        this.monitor.startComponent(BIMonitor.componentName(componentClass, method));
    }

    public void endComponent(Class componentClass, String method) {
        this.assertIsInRequest();
        this.monitor.endComponent(BIMonitor.componentName(componentClass, method));
    }

    public void endComponent(Class componentClass, String method, int dataLength) {
        this.assertIsInRequest();
        this.monitor.endComponent(BIMonitor.componentName(componentClass, method), dataLength);
    }

    public void compAction(Class componentClass, String method, String action) {
        this.assertIsInRequest();
        this.monitor.compAction(BIMonitor.componentName(componentClass, method), action);
    }

    public boolean isJarmActiveForRequest() {
        this.assertIsInRequest();
        return this.monitor.isJarmActiveForRequest();
    }

    public boolean getMonitorSwitch() {
        this.assertIsInRequest();
        return this.monitor.getMonitorSwitch();
    }

    public boolean getTraceSwitch() {
        this.assertIsInRequest();
        return this.monitor.getTraceSwitch();
    }

    public static String componentName(Class componentClass, String method) {
        if (componentClass == null) {
            return null;
        }
        String className = componentClass.getName();
        if (className.startsWith(SDK_CLASS_PREFIX)) {
            className = className.substring(SDK_CLASS_PREFIX.length());
        }
        className.toUpperCase();
        className.replace('.', ':');
        return "BI:SDK::" + className + ':' + method;
    }

    private void assertIsInRequest() {
        if (!this.isInRequest) {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk_2000");
        }
    }

    private void endRequestInternal() {
        this.isInRequest = false;
        this.request = null;
        SatCheckHandler.deRegisterSatCheck((ISatCheck)this.satCheck);
    }

    private void startRequestInternal(IBIMonitor.Request request) {
        this.monitor = TaskMonitor.getRequestMonitor((String)this.user, (String)request.toString());
        this.request = request;
        this.isInRequest = true;
    }

    private void assertConnectionInfo() {
        if (this.connectionInfo == null) {
            this.connectionInfo = IBIConnectionInfo.DEFAULT;
        }
    }
}

