/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.util.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BICache {
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final int DEFAULT_FILL_PERCENTAGE = 90;
    private final int cacheSize;
    private Map objectsMap = null;
    private final int fillPercentage;
    private final int numberOfObjectsToRetain;

    public BICache(int cacheSize, int fillPercentage) {
        this.cacheSize = cacheSize <= 0 ? 100 : cacheSize;
        this.fillPercentage = fillPercentage <= 0 || fillPercentage > 100 ? 90 : fillPercentage;
        double retain = fillPercentage;
        retain /= 100.0;
        int retainNo = (int)Math.round(retain *= (double)cacheSize);
        this.numberOfObjectsToRetain = retainNo >= this.cacheSize ? cacheSize - 1 : retainNo;
        this.objectsMap = new HashMap(this.cacheSize);
    }

    public Object get(Object key) {
        if (this.objectsMap.containsKey(key)) {
            CacheObject cacheObject = (CacheObject)this.objectsMap.get(key);
            cacheObject.incHitCount();
            return cacheObject.getObject();
        }
        return null;
    }

    public boolean put(Object key, Object object) {
        if (this.objectsMap.containsKey(key)) {
            return false;
        }
        CacheObject cacheObject = new CacheObject(object);
        this.addToCache(key, cacheObject);
        return true;
    }

    public Object remove(Object key) {
        return this.objectsMap.remove(key);
    }

    private void addToCache(Object key, CacheObject cacheObject) {
        this.handleLifeTimeOfCachedObjects();
        this.objectsMap.put(key, cacheObject);
    }

    private void handleLifeTimeOfCachedObjects() {
        if (this.objectsMap.size() >= this.cacheSize) {
            ArrayList list = new ArrayList(this.objectsMap.values());
            Collections.sort(list);
            this.objectsMap.values().retainAll(list.subList(list.size() - this.numberOfObjectsToRetain, list.size()));
        }
    }

    private class CacheObject
    implements Comparable {
        private int hitCount = 0;
        private final Object object;

        public CacheObject(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public int getHitCount() {
            return this.hitCount;
        }

        public void incHitCount() {
            ++this.hitCount;
        }

        public int compareTo(Object o) {
            return this.getHitCount() - ((CacheObject)o).getHitCount();
        }
    }
}

